/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import com.google.common.base.Preconditions;
import org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.DocIdSetBlock;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.plan.DocIdSetPlanNode;

public class DocIdSetOperator
extends BaseOperator<DocIdSetBlock> {
    private static final String OPERATOR_NAME = "DocIdSetOperator";
    private static final ThreadLocal<int[]> THREAD_LOCAL_DOC_IDS = ThreadLocal.withInitial(() -> new int[DocIdSetPlanNode.MAX_DOC_PER_CALL]);
    private final BaseFilterOperator _filterOperator;
    private final int _maxSizeOfDocIdSet;
    private FilterBlockDocIdSet _filterBlockDocIdSet;
    private BlockDocIdIterator _blockDocIdIterator;
    private int _currentDocId = 0;

    public DocIdSetOperator(BaseFilterOperator filterOperator, int maxSizeOfDocIdSet) {
        Preconditions.checkArgument((maxSizeOfDocIdSet > 0 && maxSizeOfDocIdSet <= DocIdSetPlanNode.MAX_DOC_PER_CALL ? 1 : 0) != 0);
        this._filterOperator = filterOperator;
        this._maxSizeOfDocIdSet = maxSizeOfDocIdSet;
    }

    @Override
    protected DocIdSetBlock getNextBlock() {
        if (this._currentDocId == Integer.MIN_VALUE) {
            return null;
        }
        if (this._filterBlockDocIdSet == null) {
            this._filterBlockDocIdSet = ((FilterBlock)this._filterOperator.nextBlock()).getBlockDocIdSet();
            this._blockDocIdIterator = this._filterBlockDocIdSet.iterator();
        }
        int pos = 0;
        int[] docIds = THREAD_LOCAL_DOC_IDS.get();
        for (int i = 0; i < this._maxSizeOfDocIdSet; ++i) {
            this._currentDocId = this._blockDocIdIterator.next();
            if (this._currentDocId == Integer.MIN_VALUE) break;
            docIds[pos++] = this._currentDocId;
        }
        if (pos > 0) {
            return new DocIdSetBlock(docIds, pos);
        }
        return null;
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._filterBlockDocIdSet != null ? this._filterBlockDocIdSet.getNumEntriesScannedInFilter() : 0L;
        return new ExecutionStatistics(0L, numEntriesScannedInFilter, 0L, 0L);
    }
}

