/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.minion.segment;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.core.data.readers.PinotSegmentRecordReader;
import org.apache.pinot.core.minion.segment.RecordAggregator;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;

public class ReducerRecordReader
implements RecordReader {
    private final PinotSegmentRecordReader _pinotSegmentRecordReader;
    private final RecordAggregator _recordAggregator;
    private final List<String> _groupByColumns;
    private List<GenericRow> _rowGroup = new ArrayList<GenericRow>();
    private GenericRow _nextRow = new GenericRow();
    private boolean _finished = false;
    private boolean _nextRowReturned = true;

    public ReducerRecordReader(File indexDir, RecordAggregator recordAggregator, List<String> groupByColumns) throws Exception {
        this._pinotSegmentRecordReader = new PinotSegmentRecordReader(indexDir, null, groupByColumns);
        this._recordAggregator = recordAggregator;
        this._groupByColumns = groupByColumns;
    }

    public Schema getSchema() {
        return this._pinotSegmentRecordReader.getSchema();
    }

    public void init(File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) {
    }

    public boolean hasNext() {
        if (this._finished) {
            return false;
        }
        if (!this._nextRowReturned) {
            return true;
        }
        while (this._pinotSegmentRecordReader.hasNext()) {
            GenericRow currentRow = this._pinotSegmentRecordReader.next();
            if (this._rowGroup.isEmpty() || this.haveSameGroupByColumns(this._rowGroup.iterator().next(), currentRow)) {
                this._rowGroup.add(currentRow);
                continue;
            }
            this._nextRow = this._recordAggregator.aggregateRecords(this._rowGroup);
            this._rowGroup.clear();
            this._rowGroup.add(currentRow);
            this._nextRowReturned = false;
            return true;
        }
        this._finished = true;
        if (!this._rowGroup.isEmpty()) {
            this._nextRow = this._recordAggregator.aggregateRecords(this._rowGroup);
            this._rowGroup.clear();
            this._nextRowReturned = false;
            return true;
        }
        return false;
    }

    public GenericRow next() {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) {
        Preconditions.checkState((!this._nextRowReturned ? 1 : 0) != 0);
        reuse.init(this._nextRow);
        this._nextRowReturned = true;
        return reuse;
    }

    public void rewind() {
        this._pinotSegmentRecordReader.rewind();
        this._rowGroup.clear();
        this._nextRowReturned = true;
        this._finished = false;
    }

    public void close() throws IOException {
        this._pinotSegmentRecordReader.close();
    }

    private boolean haveSameGroupByColumns(GenericRow row1, GenericRow row2) {
        for (String columnName : this._groupByColumns) {
            Object value2;
            Object value1 = row1.getValue(columnName);
            if (value1.equals(value2 = row2.getValue(columnName))) continue;
            return false;
        }
        return true;
    }
}

