/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.minion.segment;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.core.data.readers.MultiplePinotSegmentRecordReader;
import org.apache.pinot.core.minion.segment.RecordPartitioner;
import org.apache.pinot.core.segment.processing.transformer.RecordTransformer;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;

public class MapperRecordReader
implements RecordReader {
    private MultiplePinotSegmentRecordReader _multiplePinotSegmentRecordReader;
    private RecordTransformer _recordTransformer;
    private RecordPartitioner _recordPartitioner;
    private int _totalNumPartition;
    private int _currentPartition;
    private GenericRow _nextRow = new GenericRow();
    private boolean _finished = false;
    private boolean _nextRowReturned = true;

    public MapperRecordReader(List<File> indexDirs, RecordTransformer recordTransformer, RecordPartitioner recordPartitioner, int totalNumPartition, int currentPartition) throws Exception {
        this._multiplePinotSegmentRecordReader = new MultiplePinotSegmentRecordReader(indexDirs);
        this._recordPartitioner = recordPartitioner;
        this._recordTransformer = recordTransformer;
        this._totalNumPartition = totalNumPartition;
        this._currentPartition = currentPartition;
    }

    public Schema getSchema() {
        return this._multiplePinotSegmentRecordReader.getSchema();
    }

    public void init(File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) {
    }

    public boolean hasNext() {
        if (this._finished) {
            return false;
        }
        if (!this._nextRowReturned) {
            return true;
        }
        while (this._multiplePinotSegmentRecordReader.hasNext()) {
            this._nextRow = this._multiplePinotSegmentRecordReader.next(this._nextRow);
            if (this._recordPartitioner.getPartitionFromRecord(this._nextRow, this._totalNumPartition) != this._currentPartition) continue;
            this._nextRow = this._recordTransformer.transformRecord(this._nextRow);
            if (this._nextRow == null) {
                this._nextRow = new GenericRow();
                continue;
            }
            this._nextRowReturned = false;
            return true;
        }
        this._finished = true;
        return false;
    }

    public GenericRow next() {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) {
        Preconditions.checkState((!this._nextRowReturned ? 1 : 0) != 0);
        reuse.init(this._nextRow);
        this._nextRowReturned = true;
        return reuse;
    }

    public void rewind() {
        this._multiplePinotSegmentRecordReader.rewind();
        this._nextRowReturned = true;
        this._finished = false;
    }

    public void close() throws IOException {
        this._multiplePinotSegmentRecordReader.close();
    }
}

