/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.minion.rollup;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.minion.segment.RecordAggregator;
import org.apache.pinot.core.segment.processing.collector.ValueAggregator;
import org.apache.pinot.core.segment.processing.collector.ValueAggregatorFactory;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class RollupRecordAggregator
implements RecordAggregator {
    private static final String DEFAULT_VALUE_AGGREGATOR_TYPE = ValueAggregatorFactory.ValueAggregatorType.SUM.toString();
    private final Map<String, ValueAggregator> _valueAggregatorMap;
    private final Schema _schema;

    public RollupRecordAggregator(Schema schema, Map<String, String> aggregateTypes) {
        this._schema = schema;
        this._valueAggregatorMap = new HashMap<String, ValueAggregator>();
        if (aggregateTypes == null) {
            aggregateTypes = Collections.emptyMap();
        }
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn() || fieldSpec.getFieldType() != FieldSpec.FieldType.METRIC) continue;
            String metricName = fieldSpec.getName();
            String aggregateType = aggregateTypes.getOrDefault(metricName, DEFAULT_VALUE_AGGREGATOR_TYPE);
            ValueAggregator valueAggregator = ValueAggregatorFactory.getValueAggregator(aggregateType, fieldSpec.getDataType());
            this._valueAggregatorMap.put(metricName, valueAggregator);
        }
    }

    @Override
    public GenericRow aggregateRecords(List<GenericRow> rows) {
        GenericRow resultRow = rows.get(0);
        for (int i = 1; i < rows.size(); ++i) {
            GenericRow currentRow = rows.get(i);
            for (MetricFieldSpec metric : this._schema.getMetricFieldSpecs()) {
                String metricName = metric.getName();
                ValueAggregator aggregator = this._valueAggregatorMap.get(metricName);
                Object aggregatedResult = aggregator.aggregate(resultRow.getValue(metricName), currentRow.getValue(metricName));
                resultRow.putValue(metricName, aggregatedResult);
            }
        }
        return resultRow;
    }
}

