/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.minion;

import java.io.File;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.common.segment.ReadMode;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.core.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.core.io.compression.ChunkCompressorFactory;
import org.apache.pinot.core.segment.creator.ForwardIndexCreator;
import org.apache.pinot.core.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.core.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.core.segment.creator.impl.V1Constants;
import org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.core.segment.index.metadata.ColumnMetadata;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.util.CrcUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawIndexConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawIndexConverter.class);
    private static final int CONVERSION_THRESHOLD = 4;
    private static final int BITS_PER_ELEMENT_FOR_RAW_INDEX = -1;
    private final String _rawTableName;
    private final ImmutableSegment _originalImmutableSegment;
    private final SegmentMetadataImpl _originalSegmentMetadata;
    private final File _convertedIndexDir;
    private final PropertiesConfiguration _convertedProperties;
    private final String _columnsToConvert;

    public RawIndexConverter(String rawTableName, File originalIndexDir, File convertedIndexDir, @Nullable String columnsToConvert) throws Exception {
        FileUtils.copyDirectory((File)originalIndexDir, (File)convertedIndexDir);
        IndexLoadingConfig indexLoadingConfig = new IndexLoadingConfig();
        indexLoadingConfig.setSegmentVersion(SegmentVersion.v1);
        indexLoadingConfig.setReadMode(ReadMode.mmap);
        this._rawTableName = rawTableName;
        this._originalImmutableSegment = ImmutableSegmentLoader.load(originalIndexDir, indexLoadingConfig);
        this._originalSegmentMetadata = (SegmentMetadataImpl)this._originalImmutableSegment.getSegmentMetadata();
        this._convertedIndexDir = convertedIndexDir;
        this._convertedProperties = new PropertiesConfiguration(new File(this._convertedIndexDir, "metadata.properties"));
        this._columnsToConvert = columnsToConvert;
    }

    public boolean convert() throws Exception {
        String segmentName = this._originalSegmentMetadata.getName();
        LOGGER.info("Start converting segment: {} in table: {}", (Object)segmentName, (Object)this._rawTableName);
        ArrayList<Object> columnsToConvert = new ArrayList<Object>();
        Schema schema = this._originalSegmentMetadata.getSchema();
        if (this._columnsToConvert == null) {
            LOGGER.info("Columns to convert are not specified, check each metric column");
            for (MetricFieldSpec metricFieldSpec : schema.getMetricFieldSpecs()) {
                if (!this._originalSegmentMetadata.hasDictionary(metricFieldSpec.getName()) || !this.shouldConvertColumn((FieldSpec)metricFieldSpec)) continue;
                columnsToConvert.add(metricFieldSpec);
            }
        } else {
            LOGGER.info("Columns to convert: {}", (Object)this._columnsToConvert);
            for (String columnToConvert : StringUtils.split((String)this._columnsToConvert, (char)',')) {
                FieldSpec fieldSpec = schema.getFieldSpecFor(columnToConvert);
                if (fieldSpec == null) {
                    LOGGER.warn("Skip converting column: {} because is does not exist in the schema", columnsToConvert);
                    continue;
                }
                if (!fieldSpec.isSingleValueField()) {
                    LOGGER.warn("Skip converting column: {} because it's a multi-value column", columnsToConvert);
                    continue;
                }
                if (!this._originalSegmentMetadata.hasDictionary(columnToConvert)) {
                    LOGGER.warn("Skip converting column: {} because its index is not dictionary-based", columnsToConvert);
                    continue;
                }
                columnsToConvert.add(fieldSpec);
            }
        }
        if (columnsToConvert.isEmpty()) {
            LOGGER.info("No column converted for segment: {} in table: {}", (Object)segmentName, (Object)this._rawTableName);
            return false;
        }
        for (FieldSpec fieldSpec : columnsToConvert) {
            this.convertColumn(fieldSpec);
        }
        this._convertedProperties.save();
        SegmentIndexCreationDriverImpl.persistCreationMeta(this._convertedIndexDir, CrcUtils.forAllFilesInFolder(this._convertedIndexDir).computeCrc(), this._originalSegmentMetadata.getIndexCreationTime());
        LOGGER.info("{} columns converted for segment: {} in table: {}", new Object[]{columnsToConvert.size(), segmentName, this._rawTableName});
        return true;
    }

    private boolean shouldConvertColumn(FieldSpec fieldSpec) {
        String columnName = fieldSpec.getName();
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        int numTotalDocs = this._originalSegmentMetadata.getTotalDocs();
        ColumnMetadata columnMetadata = this._originalSegmentMetadata.getColumnMetadataFor(columnName);
        int cardinality = columnMetadata.getCardinality();
        int lengthOfEachEntry = dataType.isFixedWidth() ? dataType.size() * 8 : columnMetadata.getColumnMaxLength() * 8;
        long dictionaryBasedIndexSize = (long)numTotalDocs * (long)columnMetadata.getBitsPerElement() + (long)cardinality * (long)lengthOfEachEntry;
        long rawIndexSize = (long)numTotalDocs * (long)lengthOfEachEntry;
        LOGGER.info("For column: {}, size of dictionary based index: {} bits, size of raw index (without compression): {} bits", new Object[]{columnName, dictionaryBasedIndexSize, rawIndexSize});
        return rawIndexSize <= dictionaryBasedIndexSize * 4L;
    }

    private void convertColumn(FieldSpec fieldSpec) throws Exception {
        String columnName = fieldSpec.getName();
        LOGGER.info("Converting column: {}", (Object)columnName);
        FileUtils.deleteQuietly((File)new File(this._convertedIndexDir, columnName + ".dict"));
        FileUtils.deleteQuietly((File)new File(this._convertedIndexDir, columnName + ".sv.unsorted.fwd"));
        FileUtils.deleteQuietly((File)new File(this._convertedIndexDir, columnName + ".sv.sorted.fwd"));
        FileUtils.deleteQuietly((File)new File(this._convertedIndexDir, columnName + ".bitmap.inv"));
        DataSource dataSource = this._originalImmutableSegment.getDataSource(columnName);
        ForwardIndexReader<?> reader = dataSource.getForwardIndex();
        Dictionary dictionary = dataSource.getDictionary();
        assert (dictionary != null);
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        int numDocs = this._originalSegmentMetadata.getTotalDocs();
        int lengthOfLongestEntry = this._originalSegmentMetadata.getColumnMetadataFor(columnName).getColumnMaxLength();
        try (ForwardIndexCreator rawIndexCreator = SegmentColumnarIndexCreator.getRawIndexCreatorForColumn(this._convertedIndexDir, ChunkCompressorFactory.CompressionType.SNAPPY, columnName, dataType, numDocs, lengthOfLongestEntry, false, 2);
             Object readerContext = reader.createContext();){
            switch (dataType) {
                case INT: {
                    int docId;
                    for (docId = 0; docId < numDocs; ++docId) {
                        rawIndexCreator.putInt(dictionary.getIntValue(reader.getDictId(docId, readerContext)));
                    }
                    break;
                }
                case LONG: {
                    int docId;
                    for (docId = 0; docId < numDocs; ++docId) {
                        rawIndexCreator.putLong(dictionary.getLongValue(reader.getDictId(docId, readerContext)));
                    }
                    break;
                }
                case FLOAT: {
                    int docId;
                    for (docId = 0; docId < numDocs; ++docId) {
                        rawIndexCreator.putFloat(dictionary.getFloatValue(reader.getDictId(docId, readerContext)));
                    }
                    break;
                }
                case DOUBLE: {
                    int docId;
                    for (docId = 0; docId < numDocs; ++docId) {
                        rawIndexCreator.putDouble(dictionary.getDoubleValue(reader.getDictId(docId, readerContext)));
                    }
                    break;
                }
                case STRING: {
                    int docId;
                    for (docId = 0; docId < numDocs; ++docId) {
                        rawIndexCreator.putString(dictionary.getStringValue(reader.getDictId(docId, readerContext)));
                    }
                    break;
                }
                case BYTES: {
                    int docId;
                    for (docId = 0; docId < numDocs; ++docId) {
                        rawIndexCreator.putBytes(dictionary.getBytesValue(reader.getDictId(docId, readerContext)));
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this._convertedProperties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(columnName, "hasDictionary"), (Object)false);
        this._convertedProperties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(columnName, "bitsPerElement"), (Object)-1);
    }
}

