/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.io.writer.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.io.compression.ChunkCompressorFactory;
import org.apache.pinot.core.io.writer.impl.BaseChunkSVForwardIndexWriter;

@NotThreadSafe
public class VarByteChunkSVForwardIndexWriter
extends BaseChunkSVForwardIndexWriter {
    public static final int CHUNK_HEADER_ENTRY_ROW_OFFSET_SIZE = 4;
    private final int _chunkHeaderSize;
    private int _chunkHeaderOffset = 0;
    private int _chunkDataOffSet;

    public VarByteChunkSVForwardIndexWriter(File file, ChunkCompressorFactory.CompressionType compressionType, int totalDocs, int numDocsPerChunk, int lengthOfLongestEntry, int writerVersion) throws FileNotFoundException {
        super(file, compressionType, totalDocs, numDocsPerChunk, numDocsPerChunk * (4 + lengthOfLongestEntry), lengthOfLongestEntry, writerVersion);
        this._chunkDataOffSet = this._chunkHeaderSize = numDocsPerChunk * 4;
    }

    public void putString(String value) {
        this.putBytes(StringUtil.encodeUtf8((String)value));
    }

    public void putBytes(byte[] value) {
        this._chunkBuffer.putInt(this._chunkHeaderOffset, this._chunkDataOffSet);
        this._chunkHeaderOffset += 4;
        this._chunkBuffer.position(this._chunkDataOffSet);
        this._chunkBuffer.put(value);
        this._chunkDataOffSet += value.length;
        if (this._chunkHeaderOffset == this._chunkHeaderSize) {
            this.writeChunk();
        }
    }

    @Override
    public void close() throws IOException {
        if (this._chunkBuffer.position() > 0) {
            this.writeChunk();
        }
        this._header.flip();
        this._dataFile.write(this._header, 0L);
        this._dataFile.close();
    }

    @Override
    protected void writeChunk() {
        for (int i = this._chunkHeaderOffset; i < this._chunkHeaderSize; i += 4) {
            this._chunkBuffer.putInt(i, 0);
        }
        super.writeChunk();
        this._chunkHeaderOffset = 0;
        this._chunkDataOffSet = this._chunkHeaderSize;
    }
}

