/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.io.writer.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.pinot.core.io.util.FixedBitIntReaderWriter;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class FixedBitSVForwardIndexWriter
implements Closeable {
    private final PinotDataBuffer _dataBuffer;
    private final FixedBitIntReaderWriter _intReaderWriter;
    private int _nextDocId = 0;

    public FixedBitSVForwardIndexWriter(File file, int numDocs, int numBitsPerValue) throws Exception {
        long length = ((long)numDocs * (long)numBitsPerValue + 8L - 1L) / 8L;
        this._dataBuffer = PinotDataBuffer.mapFile(file, false, 0L, length, ByteOrder.BIG_ENDIAN, this.getClass().getSimpleName());
        this._intReaderWriter = new FixedBitIntReaderWriter(this._dataBuffer, numDocs, numBitsPerValue);
    }

    public void putDictId(int dictId) {
        this._intReaderWriter.writeInt(this._nextDocId++, dictId);
    }

    @Override
    public void close() throws IOException {
        this._intReaderWriter.close();
        this._dataBuffer.close();
    }
}

