/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.io.util;

import java.util.Arrays;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.io.util.ValueReader;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class VarLengthBytesValueReaderWriter
implements ValueReader {
    private static final byte[] MAGIC_BYTES = StringUtil.encodeUtf8((String)".vl;");
    private static final int VERSION = 1;
    private static final int VERSION_OFFSET = MAGIC_BYTES.length;
    private static final int NUM_ELEMENTS_OFFSET = VERSION_OFFSET + 4;
    private static final int DATA_SECTION_OFFSET_POSITION = NUM_ELEMENTS_OFFSET + 4;
    private static final int HEADER_LENGTH = DATA_SECTION_OFFSET_POSITION + 4;
    private final PinotDataBuffer _dataBuffer;
    private final int _dataSectionStartOffSet;
    private final int _numElements;

    public VarLengthBytesValueReaderWriter(PinotDataBuffer dataBuffer) {
        this._dataBuffer = dataBuffer;
        this._numElements = dataBuffer.getInt(NUM_ELEMENTS_OFFSET);
        this._dataSectionStartOffSet = dataBuffer.getInt(DATA_SECTION_OFFSET_POSITION);
    }

    public VarLengthBytesValueReaderWriter(PinotDataBuffer dataBuffer, byte[][] byteArrays) {
        this._dataBuffer = dataBuffer;
        this._numElements = byteArrays.length;
        this._dataSectionStartOffSet = HEADER_LENGTH;
        this.write(byteArrays);
    }

    public static long getRequiredSize(byte[][] byteArrays) {
        long length = HEADER_LENGTH + 4 * (byteArrays.length + 1);
        for (byte[] array : byteArrays) {
            length += (long)array.length;
        }
        return length;
    }

    public static boolean isVarLengthBytesDictBuffer(PinotDataBuffer buffer) {
        if (buffer.size() > (long)HEADER_LENGTH) {
            byte[] magicBytes = new byte[MAGIC_BYTES.length];
            buffer.copyTo(0L, magicBytes, 0, MAGIC_BYTES.length);
            if (Arrays.equals(MAGIC_BYTES, magicBytes) && 1 == buffer.getInt(MAGIC_BYTES.length)) {
                return buffer.getInt(NUM_ELEMENTS_OFFSET) >= 0 && buffer.getInt(DATA_SECTION_OFFSET_POSITION) > 0;
            }
        }
        return false;
    }

    private void writeHeader() {
        for (int offset = 0; offset < MAGIC_BYTES.length; ++offset) {
            this._dataBuffer.putByte(offset, MAGIC_BYTES[offset]);
        }
        this._dataBuffer.putInt(VERSION_OFFSET, 1);
        this._dataBuffer.putInt(NUM_ELEMENTS_OFFSET, this._numElements);
        this._dataBuffer.putInt(DATA_SECTION_OFFSET_POSITION, this._dataSectionStartOffSet);
    }

    private void write(byte[][] byteArrays) {
        this.writeHeader();
        int nextOffset = this._dataSectionStartOffSet;
        int nextArrayStartOffset = this._dataSectionStartOffSet + 4 * (byteArrays.length + 1);
        for (byte[] array : byteArrays) {
            this._dataBuffer.putInt(nextOffset, nextArrayStartOffset);
            nextOffset += 4;
            nextArrayStartOffset += array.length;
        }
        this._dataBuffer.putInt(nextOffset, nextArrayStartOffset);
        nextArrayStartOffset = this._dataSectionStartOffSet + 4 * (byteArrays.length + 1);
        for (byte[] array : byteArrays) {
            this._dataBuffer.readFrom((long)nextArrayStartOffset, array);
            nextArrayStartOffset += array.length;
        }
    }

    public int getNumElements() {
        return this._numElements;
    }

    @Override
    public int getInt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUnpaddedString(int index, int numBytesPerValue, byte paddingByte, byte[] buffer) {
        assert (buffer.length >= numBytesPerValue);
        int offset = this._dataBuffer.getInt(this._dataSectionStartOffSet + 4 * index);
        int length = this._dataBuffer.getInt(this._dataSectionStartOffSet + 4 * (index + 1)) - offset;
        assert (numBytesPerValue >= length);
        this._dataBuffer.copyTo((long)offset, buffer, 0, length);
        return StringUtil.decodeUtf8((byte[])buffer, (int)0, (int)length);
    }

    @Override
    public String getPaddedString(int index, int numBytesPerValue, byte[] buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(int index, int numBytesPerValue) {
        int offset = this._dataBuffer.getInt(this._dataSectionStartOffSet + 4 * index);
        int length = this._dataBuffer.getInt(this._dataSectionStartOffSet + 4 * (index + 1)) - offset;
        byte[] value = new byte[length];
        this._dataBuffer.copyTo(offset, value);
        return value;
    }

    @Override
    public void close() {
    }
}

