/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.io.util;

import java.io.Closeable;
import java.io.IOException;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;

public abstract class PinotDataBitSetV2
implements Closeable {
    private static final int BYTE_MASK = 255;
    static final int MAX_VALUES_UNPACKED_SINGLE_ALIGNED_READ = 16;
    private static final ThreadLocal<int[]> THREAD_LOCAL_DICT_IDS = ThreadLocal.withInitial(() -> new int[DocIdSetPlanNode.MAX_DOC_PER_CALL]);
    protected PinotDataBuffer _dataBuffer;
    protected int _numBitsPerValue;

    public abstract int readInt(long var1);

    public abstract void readInt(long var1, int var3, int[] var4);

    public void readInt(int[] docIds, int docIdsStartIndex, int length, int[] out, int outpos) {
        int startDocId = docIds[docIdsStartIndex];
        int endDocId = docIds[docIdsStartIndex + length - 1];
        int[] dictIds = THREAD_LOCAL_DICT_IDS.get();
        this.readInt(startDocId, endDocId - startDocId + 1, dictIds);
        out[outpos] = dictIds[0];
        for (int i = 1; i < length; ++i) {
            out[outpos + i] = dictIds[docIds[docIdsStartIndex + i] - startDocId];
        }
    }

    public static PinotDataBitSetV2 createBitSet(PinotDataBuffer pinotDataBuffer, int numBitsPerValue) {
        switch (numBitsPerValue) {
            case 1: {
                return new Bit1Encoded(pinotDataBuffer, numBitsPerValue);
            }
            case 2: {
                return new Bit2Encoded(pinotDataBuffer, numBitsPerValue);
            }
            case 4: {
                return new Bit4Encoded(pinotDataBuffer, numBitsPerValue);
            }
            case 8: {
                return new Bit8Encoded(pinotDataBuffer, numBitsPerValue);
            }
            case 16: {
                return new Bit16Encoded(pinotDataBuffer, numBitsPerValue);
            }
            case 32: {
                return new RawInt(pinotDataBuffer, numBitsPerValue);
            }
        }
        throw new UnsupportedOperationException(numBitsPerValue + "not supported by PinotDataBitSetV2");
    }

    protected void writeInt(int index, int value) {
        long bitOffset = (long)index * (long)this._numBitsPerValue;
        int byteOffset = (int)(bitOffset / 8L);
        int bitOffsetInFirstByte = (int)(bitOffset % 8L);
        byte firstByte = this._dataBuffer.getByte(byteOffset);
        int firstByteMask = 255 >>> bitOffsetInFirstByte;
        int numBitsLeft = this._numBitsPerValue - (8 - bitOffsetInFirstByte);
        if (numBitsLeft <= 0) {
            this._dataBuffer.putByte(byteOffset, (byte)(firstByte & ~(firstByteMask &= 255 << -numBitsLeft) | value << -numBitsLeft));
        } else {
            this._dataBuffer.putByte(byteOffset, (byte)(firstByte & ~firstByteMask | value >>> numBitsLeft & firstByteMask));
            while (numBitsLeft > 8) {
                this._dataBuffer.putByte(++byteOffset, (byte)(value >> (numBitsLeft -= 8)));
            }
            byte lastByte = this._dataBuffer.getByte(++byteOffset);
            this._dataBuffer.putByte(byteOffset, (byte)(lastByte & 255 >>> numBitsLeft | value << 8 - numBitsLeft));
        }
    }

    public void writeInt(int startIndex, int length, int[] values) {
        long startBitOffset = (long)startIndex * (long)this._numBitsPerValue;
        int byteOffset = (int)(startBitOffset / 8L);
        int bitOffsetInFirstByte = (int)(startBitOffset % 8L);
        int firstByte = this._dataBuffer.getByte(byteOffset);
        for (int i = 0; i < length; ++i) {
            int value = values[i];
            if (bitOffsetInFirstByte == 8) {
                bitOffsetInFirstByte = 0;
                firstByte = this._dataBuffer.getByte(++byteOffset);
            }
            int firstByteMask = 255 >>> bitOffsetInFirstByte;
            int numBitsLeft = this._numBitsPerValue - (8 - bitOffsetInFirstByte);
            if (numBitsLeft <= 0) {
                firstByte = firstByte & ~(firstByteMask &= 255 << -numBitsLeft) | value << -numBitsLeft;
                this._dataBuffer.putByte(byteOffset, (byte)firstByte);
                bitOffsetInFirstByte = 8 + numBitsLeft;
                continue;
            }
            this._dataBuffer.putByte(byteOffset, (byte)(firstByte & ~firstByteMask | value >>> numBitsLeft & firstByteMask));
            while (numBitsLeft > 8) {
                this._dataBuffer.putByte(++byteOffset, (byte)(value >> (numBitsLeft -= 8)));
            }
            byte lastByte = this._dataBuffer.getByte(++byteOffset);
            firstByte = lastByte & 255 >>> numBitsLeft | value << 8 - numBitsLeft;
            this._dataBuffer.putByte(byteOffset, (byte)firstByte);
            bitOffsetInFirstByte = numBitsLeft;
        }
    }

    @Override
    public void close() throws IOException {
    }

    public static class RawInt
    extends PinotDataBitSetV2 {
        RawInt(PinotDataBuffer dataBuffer, int numBits) {
            this._dataBuffer = dataBuffer;
            this._numBitsPerValue = numBits;
        }

        @Override
        public int readInt(long index) {
            return this._dataBuffer.getInt(index * 4L);
        }

        @Override
        public void readInt(long startIndex, int length, int[] out) {
            long byteOffset = startIndex * 4L;
            for (int i = 0; i < length; ++i) {
                out[i] = this._dataBuffer.getInt(byteOffset);
                byteOffset += 4L;
            }
        }
    }

    public static class Bit16Encoded
    extends PinotDataBitSetV2 {
        Bit16Encoded(PinotDataBuffer dataBuffer, int numBits) {
            this._dataBuffer = dataBuffer;
            this._numBitsPerValue = numBits;
        }

        @Override
        public int readInt(long index) {
            long bitOffset = index * (long)this._numBitsPerValue;
            long byteOffset = bitOffset / 8L;
            return this._dataBuffer.getShort(byteOffset) & 0xFFFF;
        }

        @Override
        public void readInt(long startIndex, int length, int[] out) {
            long bitOffset = startIndex * (long)this._numBitsPerValue;
            long byteOffset = bitOffset / 8L;
            int i = 0;
            while (length >= 2) {
                int packed = this._dataBuffer.getInt(byteOffset);
                out[i] = packed >>> 16;
                out[i + 1] = packed & 0xFFFF;
                length -= 2;
                i += 2;
                byteOffset += 4L;
            }
            if (length > 0) {
                out[i] = this._dataBuffer.getShort(byteOffset) & 0xFFFF;
            }
        }
    }

    public static class Bit8Encoded
    extends PinotDataBitSetV2 {
        Bit8Encoded(PinotDataBuffer dataBuffer, int numBits) {
            this._dataBuffer = dataBuffer;
            this._numBitsPerValue = numBits;
        }

        @Override
        public int readInt(long index) {
            long bitOffset = index * (long)this._numBitsPerValue;
            long byteOffset = bitOffset / 8L;
            return this._dataBuffer.getByte(byteOffset) & 0xFF;
        }

        @Override
        public void readInt(long startIndex, int length, int[] out) {
            long bitOffset = startIndex * (long)this._numBitsPerValue;
            long byteOffset = bitOffset / 8L;
            int i = 0;
            int packed = 0;
            while (length >= 4) {
                packed = this._dataBuffer.getInt(byteOffset);
                out[i] = packed >>> 24;
                out[i + 1] = packed >>> 16 & 0xFF;
                out[i + 2] = packed >>> 8 & 0xFF;
                out[i + 3] = packed & 0xFF;
                length -= 4;
                byteOffset += 4L;
                i += 4;
            }
            if (length >= 2) {
                packed = this._dataBuffer.getShort(byteOffset) & 0xFFFF;
                out[i] = packed >>> 8 & 0xFF;
                out[i + 1] = packed & 0xFF;
                length -= 2;
                byteOffset += 2L;
                i += 2;
            }
            if (length > 0) {
                out[i] = this._dataBuffer.getByte(byteOffset) & 0xFF;
            }
        }
    }

    public static class Bit4Encoded
    extends PinotDataBitSetV2 {
        Bit4Encoded(PinotDataBuffer dataBuffer, int numBits) {
            this._dataBuffer = dataBuffer;
            this._numBitsPerValue = numBits;
        }

        @Override
        public int readInt(long index) {
            long bitOffset = index * (long)this._numBitsPerValue;
            long byteOffset = bitOffset / 8L;
            int val = this._dataBuffer.getByte(byteOffset) & 0xFF;
            return (bitOffset &= 7L) == 0L ? val >>> 4 : val & 0xF;
        }

        @Override
        public void readInt(long startIndex, int length, int[] out) {
            long bitOffset = startIndex * (long)this._numBitsPerValue;
            long byteOffset = bitOffset / 8L;
            int packed = 0;
            int i = 0;
            if ((bitOffset &= 7L) != 0L) {
                packed = this._dataBuffer.getByte(byteOffset) & 0xFF;
                out[0] = packed & 0xF;
                i = 1;
                ++byteOffset;
                --length;
            }
            while (length >= 8) {
                packed = this._dataBuffer.getInt(byteOffset);
                out[i] = packed >>> 28;
                out[i + 1] = packed >>> 24 & 0xF;
                out[i + 2] = packed >>> 20 & 0xF;
                out[i + 3] = packed >>> 16 & 0xF;
                out[i + 4] = packed >>> 12 & 0xF;
                out[i + 5] = packed >>> 8 & 0xF;
                out[i + 6] = packed >>> 4 & 0xF;
                out[i + 7] = packed & 0xF;
                length -= 8;
                i += 8;
                byteOffset += 4L;
            }
            if (length >= 4) {
                packed = this._dataBuffer.getShort(byteOffset) & 0xFFFF;
                out[i] = packed >>> 12 & 0xF;
                out[i + 1] = packed >>> 8 & 0xF;
                out[i + 2] = packed >>> 4 & 0xF;
                out[i + 3] = packed & 0xF;
                length -= 4;
                i += 4;
                byteOffset += 2L;
            }
            if (length >= 2) {
                packed = this._dataBuffer.getByte(byteOffset) & 0xFF;
                out[i] = packed >>> 4;
                out[i + 1] = packed & 0xF;
                length -= 2;
                i += 2;
                ++byteOffset;
            }
            if (length > 0) {
                packed = this._dataBuffer.getByte(byteOffset) & 0xFF;
                out[i] = packed >>> 4;
            }
        }
    }

    public static class Bit2Encoded
    extends PinotDataBitSetV2 {
        Bit2Encoded(PinotDataBuffer dataBuffer, int numBits) {
            this._dataBuffer = dataBuffer;
            this._numBitsPerValue = numBits;
        }

        @Override
        public int readInt(long index) {
            long bitOffset = index * (long)this._numBitsPerValue;
            long byteOffset = bitOffset / 8L;
            int val = this._dataBuffer.getByte(byteOffset) & 0xFF;
            return val >>> (int)(6L - (bitOffset &= 7L)) & 3;
        }

        @Override
        public void readInt(long startIndex, int length, int[] out) {
            long bitOffset = startIndex * (long)this._numBitsPerValue;
            long byteOffset = bitOffset / 8L;
            int packed = 0;
            int i = 0;
            if ((bitOffset &= 7L) != 0L) {
                packed = this._dataBuffer.getByte(byteOffset) & 0xFF;
                if (bitOffset == 2L) {
                    out[0] = packed >>> 4 & 3;
                    out[1] = packed >>> 2 & 3;
                    out[2] = packed & 3;
                    i = 3;
                    length -= 3;
                } else if (bitOffset == 4L) {
                    out[0] = packed >>> 2 & 3;
                    out[1] = packed & 3;
                    i = 2;
                    length -= 2;
                } else {
                    out[0] = packed & 3;
                    i = 1;
                    --length;
                }
                ++byteOffset;
            }
            while (length >= 16) {
                packed = this._dataBuffer.getInt(byteOffset);
                out[i] = packed >>> 30;
                out[i + 1] = packed >>> 28 & 3;
                out[i + 2] = packed >>> 26 & 3;
                out[i + 3] = packed >>> 24 & 3;
                out[i + 4] = packed >>> 22 & 3;
                out[i + 5] = packed >>> 20 & 3;
                out[i + 6] = packed >>> 18 & 3;
                out[i + 7] = packed >>> 16 & 3;
                out[i + 8] = packed >>> 14 & 3;
                out[i + 9] = packed >>> 12 & 3;
                out[i + 10] = packed >>> 10 & 3;
                out[i + 11] = packed >>> 8 & 3;
                out[i + 12] = packed >>> 6 & 3;
                out[i + 13] = packed >>> 4 & 3;
                out[i + 14] = packed >>> 2 & 3;
                out[i + 15] = packed & 3;
                length -= 16;
                byteOffset += 4L;
                i += 16;
            }
            if (length >= 8) {
                packed = this._dataBuffer.getShort(byteOffset) & 0xFFFF;
                out[i] = packed >>> 14 & 3;
                out[i + 1] = packed >>> 12 & 3;
                out[i + 2] = packed >>> 10 & 3;
                out[i + 3] = packed >>> 8 & 3;
                out[i + 4] = packed >>> 6 & 3;
                out[i + 5] = packed >>> 4 & 3;
                out[i + 6] = packed >>> 2 & 3;
                out[i + 7] = packed & 3;
                length -= 8;
                byteOffset += 2L;
                i += 8;
            }
            if (length >= 4) {
                packed = this._dataBuffer.getByte(byteOffset) & 0xFF;
                out[i] = packed >>> 6;
                out[i + 1] = packed >>> 4 & 3;
                out[i + 2] = packed >>> 2 & 3;
                out[i + 3] = packed & 3;
                length -= 4;
                ++byteOffset;
                i += 4;
            }
            if (length > 0) {
                packed = this._dataBuffer.getByte(byteOffset) & 0xFF;
                out[i] = packed >>> 6;
                --length;
            }
            if (length > 0) {
                out[i + 1] = packed >>> 4 & 3;
                --length;
            }
            if (length > 0) {
                out[i + 2] = packed >>> 2 & 3;
            }
        }
    }

    public static class Bit1Encoded
    extends PinotDataBitSetV2 {
        Bit1Encoded(PinotDataBuffer dataBuffer, int numBits) {
            this._dataBuffer = dataBuffer;
            this._numBitsPerValue = numBits;
        }

        @Override
        public int readInt(long index) {
            long bitOffset = index * (long)this._numBitsPerValue;
            long byteOffset = bitOffset / 8L;
            int val = this._dataBuffer.getByte(byteOffset) & 0xFF;
            return val >>> (int)(7L - (bitOffset &= 7L)) & 1;
        }

        @Override
        public void readInt(long startIndex, int length, int[] out) {
            long bitOffset = startIndex * (long)this._numBitsPerValue;
            long byteOffset = bitOffset / 8L;
            int packed = 0;
            int i = 0;
            if ((bitOffset &= 7L) != 0L) {
                packed = this._dataBuffer.getByte(byteOffset) & 0xFF;
                if (bitOffset == 1L) {
                    out[0] = packed >>> 6 & 1;
                    out[1] = packed >>> 5 & 1;
                    out[2] = packed >>> 4 & 1;
                    out[3] = packed >>> 3 & 1;
                    out[4] = packed >>> 2 & 1;
                    out[5] = packed >>> 1 & 1;
                    out[6] = packed & 1;
                    i = 7;
                    length -= 7;
                } else if (bitOffset == 2L) {
                    out[0] = packed >>> 5 & 1;
                    out[1] = packed >>> 4 & 1;
                    out[2] = packed >>> 3 & 1;
                    out[3] = packed >>> 2 & 1;
                    out[4] = packed >>> 1 & 1;
                    out[5] = packed & 1;
                    i = 6;
                    length -= 6;
                } else if (bitOffset == 3L) {
                    out[0] = packed >>> 4 & 1;
                    out[1] = packed >>> 3 & 1;
                    out[2] = packed >>> 2 & 1;
                    out[3] = packed >>> 1 & 1;
                    out[4] = packed & 1;
                    i = 5;
                    length -= 5;
                } else if (bitOffset == 4L) {
                    out[0] = packed >>> 3 & 1;
                    out[1] = packed >>> 2 & 1;
                    out[2] = packed >>> 1 & 1;
                    out[3] = packed & 1;
                    i = 4;
                    length -= 4;
                } else if (bitOffset == 5L) {
                    out[0] = packed >>> 2 & 1;
                    out[1] = packed >>> 1 & 1;
                    out[2] = packed & 1;
                    i = 3;
                    length -= 3;
                } else if (bitOffset == 6L) {
                    out[0] = packed >>> 1 & 1;
                    out[1] = packed & 1;
                    i = 2;
                    length -= 2;
                } else {
                    out[0] = packed & 1;
                    i = 1;
                    --length;
                }
                ++byteOffset;
            }
            while (length >= 32) {
                packed = this._dataBuffer.getInt(byteOffset);
                out[i] = packed >>> 31;
                out[i + 1] = packed >>> 30 & 1;
                out[i + 2] = packed >>> 29 & 1;
                out[i + 3] = packed >>> 28 & 1;
                out[i + 4] = packed >>> 27 & 1;
                out[i + 5] = packed >>> 26 & 1;
                out[i + 6] = packed >>> 25 & 1;
                out[i + 7] = packed >>> 24 & 1;
                out[i + 8] = packed >>> 23 & 1;
                out[i + 9] = packed >>> 22 & 1;
                out[i + 10] = packed >>> 21 & 1;
                out[i + 11] = packed >>> 20 & 1;
                out[i + 12] = packed >>> 19 & 1;
                out[i + 13] = packed >>> 18 & 1;
                out[i + 14] = packed >>> 17 & 1;
                out[i + 15] = packed >>> 16 & 1;
                out[i + 16] = packed >>> 15 & 1;
                out[i + 17] = packed >>> 14 & 1;
                out[i + 18] = packed >>> 13 & 1;
                out[i + 19] = packed >>> 12 & 1;
                out[i + 20] = packed >>> 11 & 1;
                out[i + 21] = packed >>> 10 & 1;
                out[i + 22] = packed >>> 9 & 1;
                out[i + 23] = packed >>> 8 & 1;
                out[i + 24] = packed >>> 7 & 1;
                out[i + 25] = packed >>> 6 & 1;
                out[i + 26] = packed >>> 5 & 1;
                out[i + 27] = packed >>> 4 & 1;
                out[i + 28] = packed >>> 3 & 1;
                out[i + 29] = packed >>> 2 & 1;
                out[i + 30] = packed >>> 1 & 1;
                out[i + 31] = packed & 1;
                length -= 32;
                byteOffset += 4L;
                i += 32;
            }
            if (length >= 16) {
                packed = this._dataBuffer.getShort(byteOffset) & 0xFFFF;
                out[i] = packed >>> 15 & 1;
                out[i + 1] = packed >>> 14 & 1;
                out[i + 2] = packed >>> 13 & 1;
                out[i + 3] = packed >>> 12 & 1;
                out[i + 4] = packed >>> 11 & 1;
                out[i + 5] = packed >>> 10 & 1;
                out[i + 6] = packed >>> 9 & 1;
                out[i + 7] = packed >>> 8 & 1;
                out[i + 8] = packed >>> 7 & 1;
                out[i + 9] = packed >>> 6 & 1;
                out[i + 10] = packed >>> 5 & 1;
                out[i + 11] = packed >>> 4 & 1;
                out[i + 12] = packed >>> 3 & 1;
                out[i + 13] = packed >>> 2 & 1;
                out[i + 14] = packed >>> 1 & 1;
                out[i + 15] = packed & 1;
                length -= 16;
                byteOffset += 2L;
                i += 16;
            }
            if (length >= 8) {
                packed = this._dataBuffer.getByte(byteOffset) & 0xFF;
                out[i] = packed >>> 7 & 1;
                out[i + 1] = packed >>> 6 & 1;
                out[i + 2] = packed >>> 5 & 1;
                out[i + 3] = packed >>> 4 & 1;
                out[i + 4] = packed >>> 3 & 1;
                out[i + 5] = packed >>> 2 & 1;
                out[i + 6] = packed >>> 1 & 1;
                out[i + 7] = packed & 1;
                length -= 8;
                ++byteOffset;
                i += 8;
            }
            if (length == 7) {
                packed = this._dataBuffer.getByte(byteOffset) & 0xFF;
                out[i] = packed >>> 7 & 1;
                out[i + 1] = packed >>> 6 & 1;
                out[i + 2] = packed >>> 5 & 1;
                out[i + 3] = packed >>> 4 & 1;
                out[i + 4] = packed >>> 3 & 1;
                out[i + 5] = packed >>> 2 & 1;
                out[i + 6] = packed >>> 1 & 1;
            } else if (length == 6) {
                out[i] = packed >>> 7 & 1;
                out[i + 1] = packed >>> 6 & 1;
                out[i + 2] = packed >>> 5 & 1;
                out[i + 3] = packed >>> 4 & 1;
                out[i + 4] = packed >>> 3 & 1;
                out[i + 5] = packed >>> 2 & 1;
            } else if (length == 5) {
                out[i] = packed >>> 7 & 1;
                out[i + 1] = packed >>> 6 & 1;
                out[i + 2] = packed >>> 5 & 1;
                out[i + 3] = packed >>> 4 & 1;
                out[i + 4] = packed >>> 3 & 1;
            } else if (length == 4) {
                out[i] = packed >>> 7 & 1;
                out[i + 1] = packed >>> 6 & 1;
                out[i + 2] = packed >>> 5 & 1;
                out[i + 3] = packed >>> 4 & 1;
            } else if (length == 3) {
                out[i] = packed >>> 7 & 1;
                out[i + 1] = packed >>> 6 & 1;
                out[i + 2] = packed >>> 5 & 1;
            } else if (length == 2) {
                out[i] = packed >>> 7 & 1;
                out[i + 1] = packed >>> 6 & 1;
            } else {
                out[i] = packed >>> 7 & 1;
            }
        }
    }
}

