/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.io.util;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import org.apache.pinot.core.io.util.PinotDataBitSetV2;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;

public final class FixedBitIntReaderWriterV2
implements Closeable {
    private PinotDataBitSetV2 _dataBitSet;

    public FixedBitIntReaderWriterV2(PinotDataBuffer dataBuffer, int numValues, int numBitsPerValue) {
        Preconditions.checkState((dataBuffer.size() == (long)((int)(((long)numValues * (long)numBitsPerValue + 8L - 1L) / 8L)) ? 1 : 0) != 0);
        this._dataBitSet = PinotDataBitSetV2.createBitSet(dataBuffer, numBitsPerValue);
    }

    public int readInt(int index) {
        return this._dataBitSet.readInt(index);
    }

    public void readInt(int startDocId, int length, int[] buffer) {
        this._dataBitSet.readInt(startDocId, length, buffer);
    }

    public void readValues(int[] docIds, int docIdStartIndex, int docIdLength, int[] values, int valuesStartIndex) {
        int i;
        int docIdEndIndex;
        int bulkReadChunks = docIdLength / 16;
        int remainingChunk = docIdLength % 16;
        while (bulkReadChunks > 0) {
            docIdEndIndex = docIdStartIndex + 16 - 1;
            if (this.shouldBulkRead(docIds, docIdStartIndex, docIdEndIndex)) {
                this._dataBitSet.readInt(docIds, docIdStartIndex, 16, values, valuesStartIndex);
                valuesStartIndex += 16;
            } else {
                for (i = docIdStartIndex; i <= docIdEndIndex; ++i) {
                    values[valuesStartIndex++] = this._dataBitSet.readInt(docIds[i]);
                }
            }
            docIdStartIndex += 16;
            --bulkReadChunks;
            docIdLength -= 16;
        }
        if (remainingChunk > 0) {
            docIdEndIndex = docIdStartIndex + docIdLength - 1;
            for (i = docIdStartIndex; i <= docIdEndIndex; ++i) {
                values[valuesStartIndex++] = this._dataBitSet.readInt(docIds[i]);
            }
        }
    }

    private boolean shouldBulkRead(int[] docIds, int startIndex, int endIndex) {
        int numDocsToRead = endIndex - startIndex + 1;
        int docIdRange = docIds[endIndex] - docIds[startIndex] + 1;
        return (double)numDocsToRead >= (double)docIdRange * 0.5;
    }

    public void writeInt(int index, int value) {
        this._dataBitSet.writeInt(index, value);
    }

    public void writeInt(int startIndex, int length, int[] values) {
        this._dataBitSet.writeInt(startIndex, length, values);
    }

    @Override
    public void close() throws IOException {
        if (this._dataBitSet != null) {
            this._dataBitSet.close();
        }
    }
}

