/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.io.readerwriter.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.core.io.reader.impl.FixedByteSingleValueMultiColReader;
import org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.core.io.writer.impl.FixedByteSingleValueMultiColWriter;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class FixedByteSingleValueMultiColumnReaderWriter
implements Closeable {
    private final List<FixedByteSingleValueMultiColWriter> _writers;
    private volatile List<FixedByteSingleValueMultiColReader> _readers;
    private final int _numRowsPerChunk;
    private final int[] _columnSizesInBytes;
    private final PinotDataBufferMemoryManager _memoryManager;
    private String _allocationContext;
    private final long _chunkSizeInBytes;
    private int _capacityInRows;
    private int _numColumns;

    public FixedByteSingleValueMultiColumnReaderWriter(int numRowsPerChunk, int[] columnSizesInBytes, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        this._numRowsPerChunk = numRowsPerChunk;
        this._columnSizesInBytes = columnSizesInBytes;
        this._memoryManager = memoryManager;
        this._allocationContext = allocationContext;
        this._writers = new ArrayList<FixedByteSingleValueMultiColWriter>();
        this._readers = new ArrayList<FixedByteSingleValueMultiColReader>();
        this._capacityInRows = 0;
        int rowSizeInBytes = 0;
        for (int columnSizesInByte : columnSizesInBytes) {
            rowSizeInBytes += columnSizesInByte;
        }
        this._numColumns = this._columnSizesInBytes.length;
        this._chunkSizeInBytes = rowSizeInBytes * numRowsPerChunk;
    }

    public int getInt(int row, int column) {
        int rowInChunk = row % this._numRowsPerChunk;
        int chunkId = row / this._numRowsPerChunk;
        return this._readers.get(chunkId).getInt(rowInChunk, column);
    }

    public long getLong(int row, int column) {
        int rowInChunk = row % this._numRowsPerChunk;
        int chunkId = row / this._numRowsPerChunk;
        return this._readers.get(chunkId).getLong(rowInChunk, column);
    }

    public float getFloat(int row, int column) {
        int rowInChunk = row % this._numRowsPerChunk;
        int chunkId = row / this._numRowsPerChunk;
        return this._readers.get(chunkId).getFloat(rowInChunk, column);
    }

    public double getDouble(int row, int column) {
        int rowInChunk = row % this._numRowsPerChunk;
        int chunkId = row / this._numRowsPerChunk;
        return this._readers.get(chunkId).getDouble(rowInChunk, column);
    }

    public String getString(int row, int column) {
        int rowInChunk = row % this._numRowsPerChunk;
        int chunkId = row / this._numRowsPerChunk;
        return this._readers.get(chunkId).getString(rowInChunk, column);
    }

    public void setInt(int row, int column, int value) {
        this.ensureCapacity(row);
        int rowInChunk = row % this._numRowsPerChunk;
        int chunkId = row / this._numRowsPerChunk;
        this._writers.get(chunkId).setInt(rowInChunk, column, value);
    }

    public void setLong(int row, int column, long value) {
        this.ensureCapacity(row);
        int rowInChunk = row % this._numRowsPerChunk;
        int chunkId = row / this._numRowsPerChunk;
        this._writers.get(chunkId).setLong(rowInChunk, column, value);
    }

    public void setFloat(int row, int column, float value) {
        this.ensureCapacity(row);
        int rowInChunk = row % this._numRowsPerChunk;
        int chunkId = row / this._numRowsPerChunk;
        this._writers.get(chunkId).setFloat(rowInChunk, column, value);
    }

    public void setDouble(int row, int column, double value) {
        this.ensureCapacity(row);
        int rowInChunk = row % this._numRowsPerChunk;
        int chunkId = row / this._numRowsPerChunk;
        this._writers.get(chunkId).setDouble(rowInChunk, column, value);
    }

    public void setString(int row, int column, String value) {
        this.ensureCapacity(row);
        int rowInChunk = row % this._numRowsPerChunk;
        int chunkId = row / this._numRowsPerChunk;
        this._writers.get(chunkId).setString(rowInChunk, column, value);
    }

    @Override
    public void close() throws IOException {
        for (FixedByteSingleValueMultiColWriter writer : this._writers) {
            writer.close();
        }
        for (FixedByteSingleValueMultiColReader reader : this._readers) {
            reader.close();
        }
    }

    private void ensureCapacity(int row) {
        if (row >= this._capacityInRows) {
            long buffersNeeded = (row + 1 - this._capacityInRows + this._numRowsPerChunk) / this._numRowsPerChunk;
            int i = 0;
            while ((long)i < buffersNeeded) {
                this.addBuffer();
                ++i;
            }
        }
    }

    private void addBuffer() {
        PinotDataBuffer buffer = this._memoryManager.allocate(this._chunkSizeInBytes, this._allocationContext);
        this._capacityInRows += this._numRowsPerChunk;
        this._writers.add(new FixedByteSingleValueMultiColWriter(buffer, this._numColumns, this._columnSizesInBytes));
        FixedByteSingleValueMultiColReader reader = new FixedByteSingleValueMultiColReader(buffer, this._numRowsPerChunk, this._columnSizesInBytes);
        ArrayList<FixedByteSingleValueMultiColReader> readers = new ArrayList<FixedByteSingleValueMultiColReader>(this._readers);
        readers.add(reader);
        this._readers = readers;
    }
}

