/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.io.reader.impl;

import java.io.Closeable;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class FixedByteSingleValueMultiColReader
implements Closeable {
    private final PinotDataBuffer _dataBuffer;
    private final int _numRows;
    private final int[] _columnSizes;
    private final int[] _columnOffSets;
    private final int _rowSize;

    public FixedByteSingleValueMultiColReader(PinotDataBuffer dataBuffer, int numRows, int[] columnSizes) {
        this._dataBuffer = dataBuffer;
        this._numRows = numRows;
        this._columnSizes = columnSizes;
        int numColumns = this._columnSizes.length;
        this._columnOffSets = new int[numColumns];
        int offset = 0;
        for (int i = 0; i < numColumns; ++i) {
            this._columnOffSets[i] = offset;
            offset += columnSizes[i];
        }
        this._rowSize = offset;
    }

    private int computeOffset(int row, int col) {
        int offset = row * this._rowSize + this._columnOffSets[col];
        return offset;
    }

    public char getChar(int row, int col) {
        int offset = this.computeOffset(row, col);
        return this._dataBuffer.getChar(offset);
    }

    public short getShort(int row, int col) {
        int offset = this.computeOffset(row, col);
        return this._dataBuffer.getShort(offset);
    }

    public int getInt(int row, int col) {
        assert (this.getColumnSizes()[col] == 4);
        int offset = this.computeOffset(row, col);
        return this._dataBuffer.getInt(offset);
    }

    public long getLong(int row, int col) {
        assert (this.getColumnSizes()[col] == 8);
        int offset = this.computeOffset(row, col);
        return this._dataBuffer.getLong(offset);
    }

    public float getFloat(int row, int col) {
        assert (this.getColumnSizes()[col] == 4);
        int offset = this.computeOffset(row, col);
        return this._dataBuffer.getFloat(offset);
    }

    public double getDouble(int row, int col) {
        assert (this.getColumnSizes()[col] == 8);
        int offset = this.computeOffset(row, col);
        return this._dataBuffer.getDouble(offset);
    }

    public String getString(int row, int col) {
        return StringUtil.decodeUtf8((byte[])this.getBytes(row, col));
    }

    public byte[] getBytes(int row, int col) {
        int length = this.getColumnSizes()[col];
        byte[] dst = new byte[length];
        int offset = this.computeOffset(row, col);
        this._dataBuffer.copyTo((long)offset, dst, 0, length);
        return dst;
    }

    public int getNumberOfRows() {
        return this._numRows;
    }

    public int[] getColumnSizes() {
        return this._columnSizes;
    }

    public boolean open() {
        return false;
    }

    public void readIntValues(int[] rows, int col, int startPos, int limit, int[] values, int outStartPos) {
        int endPos = startPos + limit;
        for (int iter = startPos; iter < endPos; ++iter) {
            values[outStartPos++] = this.getInt(rows[iter], col);
        }
    }

    public void readLongValues(int[] rows, int col, int startPos, int limit, long[] values, int outStartPos) {
        int endPos = startPos + limit;
        for (int iter = startPos; iter < endPos; ++iter) {
            values[outStartPos++] = this.getLong(rows[iter], col);
        }
    }

    public void readFloatValues(int[] rows, int col, int startPos, int limit, float[] values, int outStartPos) {
        int endPos = startPos + limit;
        for (int iter = startPos; iter < endPos; ++iter) {
            values[outStartPos++] = this.getFloat(rows[iter], col);
        }
    }

    public void readDoubleValues(int[] rows, int col, int startPos, int limit, double[] values, int outStartPos) {
        int endPos = startPos + limit;
        for (int iter = startPos; iter < endPos; ++iter) {
            values[outStartPos++] = this.getDouble(rows[iter], col);
        }
    }

    public void readStringValues(int[] rows, int col, int startPos, int limit, String[] values, int outStartPos) {
        int endPos = startPos + limit;
        for (int iter = startPos; iter < endPos; ++iter) {
            values[outStartPos++] = this.getString(rows[iter], col);
        }
    }

    @Override
    public void close() {
    }
}

