/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.indexsegment.immutable;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.segment.ReadMode;
import org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.core.indexsegment.immutable.ImmutableSegmentImpl;
import org.apache.pinot.core.segment.index.column.ColumnIndexContainer;
import org.apache.pinot.core.segment.index.column.PhysicalColumnIndexContainer;
import org.apache.pinot.core.segment.index.converter.SegmentFormatConverterFactory;
import org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.core.segment.index.loader.SegmentPreProcessor;
import org.apache.pinot.core.segment.index.metadata.ColumnMetadata;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.core.segment.store.SegmentDirectoryPaths;
import org.apache.pinot.core.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.core.segment.virtualcolumn.VirtualColumnProvider;
import org.apache.pinot.core.segment.virtualcolumn.VirtualColumnProviderFactory;
import org.apache.pinot.core.startree.v2.store.StarTreeIndexContainer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableSegmentLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableSegmentLoader.class);

    private ImmutableSegmentLoader() {
    }

    public static ImmutableSegment load(File indexDir, ReadMode readMode) throws Exception {
        IndexLoadingConfig defaultIndexLoadingConfig = new IndexLoadingConfig();
        defaultIndexLoadingConfig.setReadMode(readMode);
        return ImmutableSegmentLoader.load(indexDir, defaultIndexLoadingConfig, null);
    }

    public static ImmutableSegment load(File indexDir, IndexLoadingConfig indexLoadingConfig) throws Exception {
        return ImmutableSegmentLoader.load(indexDir, indexLoadingConfig, null);
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableSegment load(File indexDir, IndexLoadingConfig indexLoadingConfig, @Nullable Schema schema) throws Exception {
        void var11_19;
        Object converter;
        SegmentVersion segmentVersionOnDisk;
        Preconditions.checkArgument((boolean)indexDir.isDirectory(), (String)"Index directory: %s does not exist or is not a directory", (Object)indexDir);
        String segmentName = indexDir.getName();
        SegmentVersion segmentVersionToLoad = indexLoadingConfig.getSegmentVersion();
        if (segmentVersionToLoad != null && !SegmentDirectoryPaths.segmentDirectoryFor(indexDir, segmentVersionToLoad).isDirectory() && (segmentVersionOnDisk = new SegmentMetadataImpl(indexDir).getSegmentVersion()) != segmentVersionToLoad) {
            LOGGER.info("Segment: {} needs to be converted from version: {} to {}", new Object[]{segmentName, segmentVersionOnDisk, segmentVersionToLoad});
            converter = SegmentFormatConverterFactory.getConverter(segmentVersionOnDisk, segmentVersionToLoad);
            LOGGER.info("Using converter: {} to up-convert segment: {}", (Object)converter.getClass().getName(), (Object)segmentName);
            converter.convert(indexDir);
            LOGGER.info("Successfully up-converted segment: {} from version: {} to {}", new Object[]{segmentName, segmentVersionOnDisk, segmentVersionToLoad});
        }
        SegmentPreProcessor preProcessor = new SegmentPreProcessor(indexDir, indexLoadingConfig, schema);
        converter = null;
        try {
            preProcessor.process();
        }
        catch (Throwable throwable) {
            converter = throwable;
            throw throwable;
        }
        finally {
            if (preProcessor != null) {
                if (converter != null) {
                    try {
                        preProcessor.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)converter).addSuppressed(throwable);
                    }
                } else {
                    preProcessor.close();
                }
            }
        }
        SegmentMetadataImpl segmentMetadata = new SegmentMetadataImpl(indexDir);
        ReadMode readMode = indexLoadingConfig.getReadMode();
        SegmentDirectory segmentDirectory = SegmentDirectory.createFromLocalFS(indexDir, segmentMetadata, readMode);
        SegmentDirectory.Reader segmentReader = segmentDirectory.createReader();
        HashMap<String, ColumnIndexContainer> indexContainerMap = new HashMap<String, ColumnIndexContainer>();
        for (Map.Entry<String, ColumnMetadata> entry : segmentMetadata.getColumnMetadataMap().entrySet()) {
            indexContainerMap.put(entry.getKey(), new PhysicalColumnIndexContainer(segmentReader, entry.getValue(), indexLoadingConfig, indexDir));
        }
        Schema segmentSchema = segmentMetadata.getSchema();
        VirtualColumnProviderFactory.addBuiltInVirtualColumnsToSegmentSchema(segmentSchema, segmentName);
        for (FieldSpec fieldSpec : segmentSchema.getAllFieldSpecs()) {
            if (!fieldSpec.isVirtualColumn()) continue;
            String columnName = fieldSpec.getName();
            VirtualColumnContext context = new VirtualColumnContext(fieldSpec, segmentMetadata.getTotalDocs());
            VirtualColumnProvider provider = VirtualColumnProviderFactory.buildProvider(context);
            indexContainerMap.put(columnName, provider.buildColumnIndexContainer(context));
            segmentMetadata.getColumnMetadataMap().put(columnName, provider.buildMetadata(context));
        }
        Object var11_17 = null;
        if (segmentMetadata.getStarTreeV2MetadataList() != null) {
            StarTreeIndexContainer starTreeIndexContainer = new StarTreeIndexContainer(SegmentDirectoryPaths.findSegmentDirectory(indexDir), segmentMetadata, indexContainerMap, readMode);
        }
        ImmutableSegmentImpl segment = new ImmutableSegmentImpl(segmentDirectory, segmentMetadata, indexContainerMap, (StarTreeIndexContainer)var11_19);
        LOGGER.info("Successfully loaded segment {} with readMode: {}", (Object)segmentName, (Object)readMode);
        return segment;
    }
}

