/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.indexsegment.immutable;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.core.realtime.impl.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.core.segment.index.column.ColumnIndexContainer;
import org.apache.pinot.core.segment.index.datasource.ImmutableDataSource;
import org.apache.pinot.core.segment.index.metadata.ColumnMetadata;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.core.segment.index.readers.ValidDocIndexReader;
import org.apache.pinot.core.segment.index.readers.ValidDocIndexReaderImpl;
import org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.core.startree.v2.StarTreeV2;
import org.apache.pinot.core.startree.v2.store.StarTreeIndexContainer;
import org.apache.pinot.core.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableSegmentImpl
implements ImmutableSegment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableSegmentImpl.class);
    private final SegmentDirectory _segmentDirectory;
    private final SegmentMetadataImpl _segmentMetadata;
    private final Map<String, ColumnIndexContainer> _indexContainerMap;
    private final StarTreeIndexContainer _starTreeIndexContainer;
    private PartitionUpsertMetadataManager _partitionUpsertMetadataManager;
    private ThreadSafeMutableRoaringBitmap _validDocIds;
    private ValidDocIndexReader _validDocIndex;

    public ImmutableSegmentImpl(SegmentDirectory segmentDirectory, SegmentMetadataImpl segmentMetadata, Map<String, ColumnIndexContainer> columnIndexContainerMap, @Nullable StarTreeIndexContainer starTreeIndexContainer) {
        this._segmentDirectory = segmentDirectory;
        this._segmentMetadata = segmentMetadata;
        this._indexContainerMap = columnIndexContainerMap;
        this._starTreeIndexContainer = starTreeIndexContainer;
    }

    public void enableUpsert(PartitionUpsertMetadataManager partitionUpsertMetadataManager, ThreadSafeMutableRoaringBitmap validDocIds) {
        this._partitionUpsertMetadataManager = partitionUpsertMetadataManager;
        this._validDocIds = validDocIds;
        this._validDocIndex = new ValidDocIndexReaderImpl(validDocIds);
    }

    @Override
    public Dictionary getDictionary(String column) {
        ColumnIndexContainer container = this._indexContainerMap.get(column);
        if (container == null) {
            throw new NullPointerException("Invalid column: " + column);
        }
        return container.getDictionary();
    }

    @Override
    public ForwardIndexReader getForwardIndex(String column) {
        return this._indexContainerMap.get(column).getForwardIndex();
    }

    @Override
    public InvertedIndexReader getInvertedIndex(String column) {
        return this._indexContainerMap.get(column).getInvertedIndex();
    }

    @Override
    public long getSegmentSizeBytes() {
        return this._segmentDirectory.getDiskSizeBytes();
    }

    @Override
    public String getSegmentName() {
        return this._segmentMetadata.getName();
    }

    @Override
    public SegmentMetadataImpl getSegmentMetadata() {
        return this._segmentMetadata;
    }

    @Override
    public DataSource getDataSource(String column) {
        ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
        Preconditions.checkNotNull((Object)columnMetadata, (Object)("ColumnMetadata for " + column + " should not be null. Potentially invalid column name specified."));
        return new ImmutableDataSource(columnMetadata, this._indexContainerMap.get(column));
    }

    @Override
    public Set<String> getColumnNames() {
        return this._segmentMetadata.getSchema().getColumnNames();
    }

    @Override
    public Set<String> getPhysicalColumnNames() {
        return this._segmentMetadata.getSchema().getPhysicalColumnNames();
    }

    @Override
    public void destroy() {
        String segmentName = this.getSegmentName();
        LOGGER.info("Trying to destroy segment : {}", (Object)segmentName);
        for (Map.Entry<String, ColumnIndexContainer> entry : this._indexContainerMap.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close indexes for column: {}. Continuing with error.", (Object)entry.getKey(), (Object)e);
            }
        }
        try {
            this._segmentDirectory.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close segment directory: {}. Continuing with error.", (Object)this._segmentDirectory, (Object)e);
        }
        if (this._starTreeIndexContainer != null) {
            try {
                this._starTreeIndexContainer.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close star-tree. Continuing with error.", (Throwable)e);
            }
        }
        if (this._partitionUpsertMetadataManager != null) {
            this._partitionUpsertMetadataManager.removeSegment(segmentName, this._validDocIds);
        }
    }

    @Override
    public List<StarTreeV2> getStarTrees() {
        return this._starTreeIndexContainer != null ? this._starTreeIndexContainer.getStarTrees() : null;
    }

    @Override
    @Nullable
    public ValidDocIndexReader getValidDocIndex() {
        return this._validDocIndex;
    }

    @Override
    public GenericRow getRecord(int docId, GenericRow reuse) {
        throw new UnsupportedOperationException();
    }

    public Map<String, ColumnIndexContainer> getIndexContainerMap() {
        return this._indexContainerMap;
    }
}

