/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.geospatial.transform.function.ScalarFunctions;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StPointFunction
extends BaseTransformFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(StPointFunction.class);
    public static final String FUNCTION_NAME = "ST_Point";
    private TransformFunction _firstArgument;
    private TransformFunction _secondArgument;
    private byte[][] _results;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0, (String)"2 arguments are required for transform function: %s", (Object)this.getName());
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"First argument must be single-valued for transform function: %s", (Object)this.getName());
        this._firstArgument = transformFunction;
        transformFunction = arguments.get(1);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Second argument must be single-valued for transform function: %s", (Object)this.getName());
        this._secondArgument = transformFunction;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BYTES_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new byte[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        double[] firstValues = this._firstArgument.transformToDoubleValuesSV(projectionBlock);
        double[] secondValues = this._secondArgument.transformToDoubleValuesSV(projectionBlock);
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            this._results[i] = ScalarFunctions.stPoint(firstValues[i], secondValues[i]);
        }
        return this._results;
    }
}

