/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.geospatial.serde.GeometrySerializer;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.spi.data.FieldSpec;
import org.locationtech.jts.geom.Geometry;

public class StEqualsFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "ST_Equals";
    private TransformFunction _firstArgument;
    private TransformFunction _secondArgument;
    private int[] _results;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0, (String)"2 arguments are required for transform function: %s", (Object)this.getName());
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"First argument must be single-valued for transform function: %s", (Object)this.getName());
        Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"The first argument must be of bytes type");
        this._firstArgument = transformFunction;
        transformFunction = arguments.get(1);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Second argument must be single-valued for transform function: %s", (Object)this.getName());
        Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"The second argument must be of bytes type");
        this._secondArgument = transformFunction;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return INT_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        byte[][] firstValues = this._firstArgument.transformToBytesValuesSV(projectionBlock);
        byte[][] secondValues = this._secondArgument.transformToBytesValuesSV(projectionBlock);
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            Geometry secondGeometry;
            Geometry firstGeometry = GeometrySerializer.deserialize(firstValues[i]);
            this._results[i] = firstGeometry.equals(secondGeometry = GeometrySerializer.deserialize(secondValues[i])) ? 1 : 0;
        }
        return this._results;
    }
}

