/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.geospatial.GeometryUtils;
import org.apache.pinot.core.geospatial.serde.GeometrySerializer;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.spi.data.FieldSpec;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class StDistanceFunction
extends BaseTransformFunction {
    private static final float MIN_LATITUDE = -90.0f;
    private static final float MAX_LATITUDE = 90.0f;
    private static final float MIN_LONGITUDE = -180.0f;
    private static final float MAX_LONGITUDE = 180.0f;
    public static final String FUNCTION_NAME = "ST_Distance";
    private TransformFunction _firstArgument;
    private TransformFunction _secondArgument;
    private double[] _results;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0, (String)"2 arguments are required for transform function: %s", (Object)this.getName());
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"First argument must be single-valued for transform function: %s", (Object)this.getName());
        Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"The first argument must be of bytes type");
        this._firstArgument = transformFunction;
        transformFunction = arguments.get(1);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Second argument must be single-valued for transform function: %s", (Object)this.getName());
        Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"The second argument must be of bytes type");
        this._secondArgument = transformFunction;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        byte[][] firstValues = this._firstArgument.transformToBytesValuesSV(projectionBlock);
        byte[][] secondValues = this._secondArgument.transformToBytesValuesSV(projectionBlock);
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            Geometry firstGeometry = GeometrySerializer.deserialize(firstValues[i]);
            Geometry secondGeometry = GeometrySerializer.deserialize(secondValues[i]);
            if (GeometryUtils.isGeography(firstGeometry) != GeometryUtils.isGeography(secondGeometry)) {
                throw new RuntimeException("The first and second arguments shall either all be geometry or all geography");
            }
            this._results[i] = GeometryUtils.isGeography(firstGeometry) ? StDistanceFunction.sphericalDistance(firstGeometry, secondGeometry) : (firstGeometry.isEmpty() || secondGeometry.isEmpty() ? Double.NaN : firstGeometry.distance(secondGeometry));
        }
        return this._results;
    }

    private static void checkLatitude(double latitude) {
        Preconditions.checkArgument((latitude >= -90.0 && latitude <= 90.0 ? 1 : 0) != 0, (Object)"Latitude must be between -90 and 90");
    }

    private static void checkLongitude(double longitude) {
        Preconditions.checkArgument((longitude >= -180.0 && longitude <= 180.0 ? 1 : 0) != 0, (Object)"Longitude must be between -180 and 180");
    }

    private static double sphericalDistance(Geometry leftGeometry, Geometry rightGeometry) {
        Preconditions.checkArgument((boolean)(leftGeometry instanceof Point), (Object)"The left argument must be a point");
        Preconditions.checkArgument((boolean)(rightGeometry instanceof Point), (Object)"The right argument must be a point");
        Point leftPoint = (Point)leftGeometry;
        Point rightPoint = (Point)rightGeometry;
        return StDistanceFunction.greatCircleDistance(leftPoint.getY(), leftPoint.getX(), rightPoint.getY(), rightPoint.getX());
    }

    private static double greatCircleDistance(double latitude1, double longitude1, double latitude2, double longitude2) {
        StDistanceFunction.checkLatitude(latitude1);
        StDistanceFunction.checkLongitude(longitude1);
        StDistanceFunction.checkLatitude(latitude2);
        StDistanceFunction.checkLongitude(longitude2);
        double radianLatitude1 = Math.toRadians(latitude1);
        double radianLatitude2 = Math.toRadians(latitude2);
        double sin1 = Math.sin(radianLatitude1);
        double cos1 = Math.cos(radianLatitude1);
        double sin2 = Math.sin(radianLatitude2);
        double cos2 = Math.cos(radianLatitude2);
        double deltaLongitude = Math.toRadians(longitude1) - Math.toRadians(longitude2);
        double cosDeltaLongitude = Math.cos(deltaLongitude);
        double t1 = cos2 * Math.sin(deltaLongitude);
        double t2 = cos1 * sin2 - sin1 * cos2 * cosDeltaLongitude;
        double t3 = sin1 * sin2 + cos1 * cos2 * cosDeltaLongitude;
        return Math.atan2(Math.sqrt(t1 * t1 + t2 * t2), t3) * 6371010.0;
    }
}

