/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.Utils;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.geospatial.serde.GeometrySerializer;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.spi.data.FieldSpec;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

abstract class ConstructFromTextFunction
extends BaseTransformFunction {
    protected TransformFunction _transformFunction;
    protected byte[][] _results;
    protected WKTReader _reader;

    ConstructFromTextFunction() {
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (String)"Exactly 1 argument is required for transform function: %s", (Object)this.getName());
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"The argument must be single-valued for transform function: %s", (Object)this.getName());
        Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"The argument must be of string type");
        this._transformFunction = transformFunction;
        this._reader = new WKTReader(this.getGeometryFactory());
    }

    protected abstract GeometryFactory getGeometryFactory();

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BYTES_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new byte[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        String[] argumentValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            try {
                Geometry geometry = this._reader.read(argumentValues[i]);
                this._results[i] = GeometrySerializer.serialize(geometry);
                continue;
            }
            catch (ParseException e) {
                Utils.rethrowException((Throwable)new RuntimeException(String.format("Failed to parse geometry from string: %s", argumentValues[i])));
            }
        }
        return this._results;
    }
}

