/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial;

import com.google.common.base.Joiner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class GeometryUtils {
    public static int GEOGRAPHY_SRID = 4326;
    public static byte GEOGRAPHY_SET_MASK = (byte)-128;
    public static byte GEOGRAPHY_GET_MASK = (byte)127;
    public static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    public static final GeometryFactory GEOGRAPHY_FACTORY = new GeometryFactory(new PrecisionModel(), GEOGRAPHY_SRID);
    public static final double EARTH_RADIUS_KM = 6371.01;
    public static final double EARTH_RADIUS_M = 6371010.0;
    public static final Joiner OR_JOINER = Joiner.on((String)" or ");
    public static final Geometry EMPTY_POINT = GEOMETRY_FACTORY.createPoint();

    private GeometryUtils() {
    }

    public static boolean isGeography(Geometry geometry) {
        return geometry.getSRID() == GEOGRAPHY_SRID;
    }
}

