/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.table;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SimpleIndexedTable
extends IndexedTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleIndexedTable.class);
    private final Map<Key, Record> _lookupMap = new HashMap<Key, Record>();
    private Iterator<Record> _iterator;
    private boolean _noMoreNewRecords = false;
    private int _numResizes = 0;
    private long _resizeTime = 0L;

    public SimpleIndexedTable(DataSchema dataSchema, QueryContext queryContext, int capacity) {
        super(dataSchema, queryContext, capacity);
    }

    @Override
    public boolean upsert(Key key, Record newRecord) {
        Preconditions.checkNotNull((Object)key, (Object)"Cannot upsert record with null keys");
        if (this._noMoreNewRecords) {
            this._lookupMap.computeIfPresent(key, (k, v) -> {
                Object[] existingValues = v.getValues();
                Object[] newValues = newRecord.getValues();
                int aggNum = 0;
                for (int i = this._numKeyColumns; i < this._numColumns; ++i) {
                    existingValues[i] = this._aggregationFunctions[aggNum++].merge(existingValues[i], newValues[i]);
                }
                return v;
            });
        } else {
            this._lookupMap.compute(key, (k, v) -> {
                if (v == null) {
                    return newRecord;
                }
                Object[] existingValues = v.getValues();
                Object[] newValues = newRecord.getValues();
                int aggNum = 0;
                for (int i = this._numKeyColumns; i < this._numColumns; ++i) {
                    existingValues[i] = this._aggregationFunctions[aggNum++].merge(existingValues[i], newValues[i]);
                }
                return v;
            });
            if (this._lookupMap.size() >= this._maxCapacity) {
                if (this._hasOrderBy) {
                    this.resize(this._capacity);
                } else {
                    this._noMoreNewRecords = true;
                }
            }
        }
        return true;
    }

    private void resize(int trimToSize) {
        long startTime = System.currentTimeMillis();
        this._tableResizer.resizeRecordsMap(this._lookupMap, trimToSize);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        ++this._numResizes;
        this._resizeTime += timeElapsed;
    }

    private List<Record> resizeAndSort(int trimToSize) {
        long startTime = System.currentTimeMillis();
        List<Record> sortedRecords = this._tableResizer.resizeAndSortRecordsMap(this._lookupMap, trimToSize);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        ++this._numResizes;
        this._resizeTime += timeElapsed;
        return sortedRecords;
    }

    @Override
    public int size() {
        return this._lookupMap.size();
    }

    @Override
    public Iterator<Record> iterator() {
        return this._iterator;
    }

    @Override
    public void finish(boolean sort) {
        if (this._hasOrderBy) {
            if (sort) {
                List<Record> sortedRecords = this.resizeAndSort(this._capacity);
                this._iterator = sortedRecords.iterator();
            } else {
                this.resize(this._capacity);
            }
            LOGGER.debug("Num resizes : {}, Total time spent in resizing : {}, Avg resize time : {}", new Object[]{this._numResizes, this._resizeTime, this._numResizes == 0 ? 0L : this._resizeTime / (long)this._numResizes});
        }
        if (this._iterator == null) {
            this._iterator = this._lookupMap.values().iterator();
        }
    }
}

