/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.table;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentIndexedTable
extends IndexedTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentIndexedTable.class);
    private final ConcurrentMap<Key, Record> _lookupMap;
    private final ReentrantReadWriteLock _readWriteLock;
    private Iterator<Record> _iterator;
    private final AtomicBoolean _noMoreNewRecords = new AtomicBoolean();
    private final AtomicInteger _numResizes = new AtomicInteger();
    private final AtomicLong _resizeTime = new AtomicLong();

    public ConcurrentIndexedTable(DataSchema dataSchema, QueryContext queryContext, int capacity) {
        super(dataSchema, queryContext, capacity);
        this._lookupMap = new ConcurrentHashMap<Key, Record>();
        this._readWriteLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean upsert(Key key, Record newRecord) {
        Preconditions.checkNotNull((Object)key, (Object)"Cannot upsert record with null keys");
        if (this._noMoreNewRecords.get()) {
            this._lookupMap.computeIfPresent(key, (k, v) -> {
                Object[] existingValues = v.getValues();
                Object[] newValues = newRecord.getValues();
                int aggNum = 0;
                for (int i = this._numKeyColumns; i < this._numColumns; ++i) {
                    existingValues[i] = this._aggregationFunctions[aggNum++].merge(existingValues[i], newValues[i]);
                }
                return v;
            });
            return true;
        }
        this._readWriteLock.readLock().lock();
        try {
            this._lookupMap.compute(key, (k, v) -> {
                if (v == null) {
                    return newRecord;
                }
                Object[] existingValues = v.getValues();
                Object[] newValues = newRecord.getValues();
                int aggNum = 0;
                for (int i = this._numKeyColumns; i < this._numColumns; ++i) {
                    existingValues[i] = this._aggregationFunctions[aggNum++].merge(existingValues[i], newValues[i]);
                }
                return v;
            });
        }
        finally {
            this._readWriteLock.readLock().unlock();
        }
        if (this._lookupMap.size() < this._maxCapacity) return true;
        if (this._hasOrderBy) {
            this._readWriteLock.writeLock().lock();
            try {
                if (this._lookupMap.size() < this._maxCapacity) return true;
                this.resize(this._capacity);
                return true;
            }
            finally {
                this._readWriteLock.writeLock().unlock();
            }
        } else {
            this._noMoreNewRecords.set(true);
        }
        return true;
    }

    @Override
    public int size() {
        return this._lookupMap.size();
    }

    @Override
    public Iterator<Record> iterator() {
        return this._iterator;
    }

    private void resize(int trimToSize) {
        long startTime = System.currentTimeMillis();
        this._tableResizer.resizeRecordsMap(this._lookupMap, trimToSize);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this._numResizes.incrementAndGet();
        this._resizeTime.addAndGet(timeElapsed);
    }

    private List<Record> resizeAndSort(int trimToSize) {
        long startTime = System.currentTimeMillis();
        List<Record> sortedRecords = this._tableResizer.resizeAndSortRecordsMap(this._lookupMap, trimToSize);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this._numResizes.incrementAndGet();
        this._resizeTime.addAndGet(timeElapsed);
        return sortedRecords;
    }

    @Override
    public void finish(boolean sort) {
        if (this._hasOrderBy) {
            if (sort) {
                List<Record> sortedRecords = this.resizeAndSort(this._capacity);
                this._iterator = sortedRecords.iterator();
            } else {
                this.resize(this._capacity);
            }
            int numResizes = this._numResizes.get();
            long resizeTime = this._resizeTime.get();
            LOGGER.debug("Num resizes : {}, Total time spent in resizing : {}, Avg resize time : {}", new Object[]{numResizes, resizeTime, numResizes == 0 ? 0L : resizeTime / (long)numResizes});
        }
        if (this._iterator == null) {
            this._iterator = this._lookupMap.values().iterator();
        }
    }
}

