/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.recordtransformer;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class NullValueTransformer
implements RecordTransformer {
    private final Map<String, Object> _defaultNullValues = new HashMap<String, Object>();

    public NullValueTransformer(Schema schema) {
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn() || fieldSpec.getFieldType() == FieldSpec.FieldType.TIME) continue;
            String fieldName = fieldSpec.getName();
            Object defaultNullValue = fieldSpec.getDefaultNullValue();
            if (fieldSpec.isSingleValueField()) {
                this._defaultNullValues.put(fieldName, defaultNullValue);
                continue;
            }
            this._defaultNullValues.put(fieldName, new Object[]{defaultNullValue});
        }
    }

    @Override
    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, Object> entry : this._defaultNullValues.entrySet()) {
            String fieldName = entry.getKey();
            Object value = record.getValue(fieldName);
            if (value != null) continue;
            record.putDefaultNullValue(fieldName, entry.getValue());
        }
        return record;
    }
}

