/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.recordtransformer;

import org.apache.pinot.core.data.function.FunctionEvaluator;
import org.apache.pinot.core.data.function.FunctionEvaluatorFactory;
import org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.readers.GenericRow;

public class FilterTransformer
implements RecordTransformer {
    private final FunctionEvaluator _evaluator;

    public FilterTransformer(TableConfig tableConfig) {
        String filterFunction = null;
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getFilterConfig() != null) {
            filterFunction = tableConfig.getIngestionConfig().getFilterConfig().getFilterFunction();
        }
        this._evaluator = filterFunction != null ? FunctionEvaluatorFactory.getExpressionEvaluator(filterFunction) : null;
    }

    @Override
    public GenericRow transform(GenericRow record) {
        Object result;
        if (this._evaluator != null && Boolean.TRUE.equals(result = this._evaluator.evaluate(record))) {
            record.putValue("$SKIP_RECORD_KEY$", (Object)true);
        }
        return record;
    }
}

