/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.recordtransformer;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.core.data.function.FunctionEvaluator;
import org.apache.pinot.core.data.function.FunctionEvaluatorFactory;
import org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.TransformConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class ExpressionTransformer
implements RecordTransformer {
    private final Map<String, FunctionEvaluator> _expressionEvaluators = new HashMap<String, FunctionEvaluator>();

    public ExpressionTransformer(TableConfig tableConfig, Schema schema) {
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getTransformConfigs() != null) {
            for (TransformConfig transformConfig : tableConfig.getIngestionConfig().getTransformConfigs()) {
                this._expressionEvaluators.put(transformConfig.getColumnName(), FunctionEvaluatorFactory.getExpressionEvaluator(transformConfig.getTransformFunction()));
            }
        }
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            FunctionEvaluator functionEvaluator;
            String fieldName = fieldSpec.getName();
            if (fieldSpec.isVirtualColumn() || this._expressionEvaluators.containsKey(fieldName) || (functionEvaluator = FunctionEvaluatorFactory.getExpressionEvaluator(fieldSpec)) == null) continue;
            this._expressionEvaluators.put(fieldName, functionEvaluator);
        }
    }

    @Override
    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, FunctionEvaluator> entry : this._expressionEvaluators.entrySet()) {
            String column = entry.getKey();
            FunctionEvaluator transformFunctionEvaluator = entry.getValue();
            if (record.getValue(column) != null) continue;
            Object result = transformFunctionEvaluator.evaluate(record);
            record.putValue(column, result);
        }
        return record;
    }
}

