/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.recordtransformer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class DataTypeTransformer
implements RecordTransformer {
    private static final Map<Class, PinotDataType> SINGLE_VALUE_TYPE_MAP = new HashMap<Class, PinotDataType>();
    private static final Map<Class, PinotDataType> MULTI_VALUE_TYPE_MAP = new HashMap<Class, PinotDataType>();
    private final Map<String, PinotDataType> _dataTypes = new HashMap<String, PinotDataType>();

    public DataTypeTransformer(Schema schema) {
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn()) continue;
            this._dataTypes.put(fieldSpec.getName(), PinotDataType.getPinotDataType((FieldSpec)fieldSpec));
        }
    }

    @Override
    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, PinotDataType> entry : this._dataTypes.entrySet()) {
            PinotDataType source;
            String column = entry.getKey();
            Object value = record.getValue(column);
            if (value == null) continue;
            PinotDataType dest = entry.getValue();
            if ((value = DataTypeTransformer.standardize(column, value, dest.isSingleValue())) == null) {
                record.putValue(column, null);
                continue;
            }
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                source = MULTI_VALUE_TYPE_MAP.get(values[0].getClass());
                if (source == null) {
                    source = PinotDataType.OBJECT_ARRAY;
                }
            } else {
                source = SINGLE_VALUE_TYPE_MAP.get(value.getClass());
                if (source == null) {
                    source = PinotDataType.OBJECT;
                }
            }
            if (source != dest) {
                value = dest.convert(value, source);
            }
            record.putValue(column, value);
        }
        return record;
    }

    @Nullable
    @VisibleForTesting
    static Object standardize(String column, @Nullable Object value, boolean isSingleValue) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            return DataTypeTransformer.standardizeCollection(column, (Collection)value, isSingleValue);
        }
        if (value instanceof Map) {
            return DataTypeTransformer.standardizeCollection(column, ((Map)value).values(), isSingleValue);
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            int numValues = values.length;
            if (numValues == 0) {
                return null;
            }
            if (numValues == 1) {
                return DataTypeTransformer.standardize(column, values[0], isSingleValue);
            }
            ArrayList<Object> standardizedValues = new ArrayList<Object>(numValues);
            for (Object singleValue : values) {
                Object standardizedValue = DataTypeTransformer.standardize(column, singleValue, true);
                if (standardizedValue == null) continue;
                standardizedValues.add(standardizedValue);
            }
            int numStandardizedValues = standardizedValues.size();
            if (numStandardizedValues == 0) {
                return null;
            }
            if (numStandardizedValues == 1) {
                return standardizedValues.get(0);
            }
            Preconditions.checkState((!isSingleValue ? 1 : 0) != 0, (String)"Cannot read single-value from Object[]: %s for column: %s", (Object)Arrays.toString(values), (Object)column);
            return standardizedValues.toArray();
        }
        return value;
    }

    private static Object standardizeCollection(String column, Collection collection, boolean isSingleValue) {
        int numValues = collection.size();
        if (numValues == 0) {
            return null;
        }
        if (numValues == 1) {
            return DataTypeTransformer.standardize(column, collection.iterator().next(), isSingleValue);
        }
        ArrayList<Object> standardizedValues = new ArrayList<Object>(numValues);
        for (Object singleValue : collection) {
            Object standardizedValue = DataTypeTransformer.standardize(column, singleValue, true);
            if (standardizedValue == null) continue;
            standardizedValues.add(standardizedValue);
        }
        int numStandardizedValues = standardizedValues.size();
        if (numStandardizedValues == 0) {
            return null;
        }
        if (numStandardizedValues == 1) {
            return standardizedValues.get(0);
        }
        Preconditions.checkState((!isSingleValue ? 1 : 0) != 0, (String)"Cannot read single-value from Collection: %s for column: %s", (Object)collection, (Object)column);
        return standardizedValues.toArray();
    }

    static {
        SINGLE_VALUE_TYPE_MAP.put(Boolean.class, PinotDataType.BOOLEAN);
        SINGLE_VALUE_TYPE_MAP.put(Byte.class, PinotDataType.BYTE);
        SINGLE_VALUE_TYPE_MAP.put(Character.class, PinotDataType.CHARACTER);
        SINGLE_VALUE_TYPE_MAP.put(Short.class, PinotDataType.SHORT);
        SINGLE_VALUE_TYPE_MAP.put(Integer.class, PinotDataType.INTEGER);
        SINGLE_VALUE_TYPE_MAP.put(Long.class, PinotDataType.LONG);
        SINGLE_VALUE_TYPE_MAP.put(Float.class, PinotDataType.FLOAT);
        SINGLE_VALUE_TYPE_MAP.put(Double.class, PinotDataType.DOUBLE);
        SINGLE_VALUE_TYPE_MAP.put(String.class, PinotDataType.STRING);
        SINGLE_VALUE_TYPE_MAP.put(byte[].class, PinotDataType.BYTES);
        MULTI_VALUE_TYPE_MAP.put(Byte.class, PinotDataType.BYTE_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(Character.class, PinotDataType.CHARACTER_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(Short.class, PinotDataType.SHORT_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(Integer.class, PinotDataType.INTEGER_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(Long.class, PinotDataType.LONG_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(Float.class, PinotDataType.FLOAT_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(Double.class, PinotDataType.DOUBLE_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(String.class, PinotDataType.STRING_ARRAY);
    }
}

