/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.recordtransformer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.core.data.recordtransformer.DataTypeTransformer;
import org.apache.pinot.core.data.recordtransformer.ExpressionTransformer;
import org.apache.pinot.core.data.recordtransformer.FilterTransformer;
import org.apache.pinot.core.data.recordtransformer.NullValueTransformer;
import org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.core.data.recordtransformer.SanitizationTransformer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class CompositeTransformer
implements RecordTransformer {
    private final List<RecordTransformer> _transformers;

    public static CompositeTransformer getDefaultTransformer(TableConfig tableConfig, Schema schema) {
        return new CompositeTransformer(Arrays.asList(new ExpressionTransformer(tableConfig, schema), new FilterTransformer(tableConfig), new DataTypeTransformer(schema), new NullValueTransformer(schema), new SanitizationTransformer(schema)));
    }

    public static CompositeTransformer getPassThroughTransformer() {
        return new CompositeTransformer(Collections.emptyList());
    }

    public CompositeTransformer(List<RecordTransformer> transformers) {
        this._transformers = transformers;
    }

    @Override
    @Nullable
    public GenericRow transform(GenericRow record) {
        for (RecordTransformer transformer : this._transformers) {
            record = transformer.transform(record);
            if (record != null) continue;
            return null;
        }
        return record;
    }
}

