/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.readers.sort;

import it.unimi.dsi.fastutil.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.data.readers.PinotSegmentColumnReader;
import org.apache.pinot.core.data.readers.sort.SegmentSorter;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class PinotSegmentSorter
implements SegmentSorter {
    private int _numDocs;
    private Schema _schema;
    private Map<String, PinotSegmentColumnReader> _columnReaderMap;
    private int[] _sortOrder;
    private List<String> _dimensionNames;
    int _numDimensions;

    public PinotSegmentSorter(int numDocs, Schema schema, Map<String, PinotSegmentColumnReader> columnReaderMap) {
        this._numDocs = numDocs;
        this._schema = schema;
        this._columnReaderMap = columnReaderMap;
        this._dimensionNames = new ArrayList<String>();
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            if (fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) continue;
            String dimensionName = fieldSpec.getName();
            ++this._numDimensions;
            this._dimensionNames.add(dimensionName);
        }
    }

    @Override
    public int[] getSortedDocIds(List<String> sortOrder) {
        this._sortOrder = new int[sortOrder.size()];
        int index = 0;
        for (String dimension : sortOrder) {
            int dimensionId = this._dimensionNames.indexOf(dimension);
            if (dimensionId != -1) {
                this._sortOrder[index++] = dimensionId;
                continue;
            }
            throw new IllegalStateException("Passed dimension in the sorting order does not exist in the schema: " + dimension);
        }
        int[] sortedDocIds = new int[this._numDocs];
        for (int i3 = 0; i3 < this._numDocs; ++i3) {
            sortedDocIds[i3] = i3;
        }
        Arrays.quickSort((int)0, (int)this._numDocs, (i1, i2) -> {
            int docId1 = sortedDocIds[i1];
            int docId2 = sortedDocIds[i2];
            int compare = 0;
            for (int sortIndex : this._sortOrder) {
                boolean isNoDictionaryColumn;
                String dimensionName = this._dimensionNames.get(sortIndex);
                FieldSpec fieldSpec = this._schema.getFieldSpecFor(dimensionName);
                PinotSegmentColumnReader columnReader = this._columnReaderMap.get(dimensionName);
                boolean isMultiValueColumn = !fieldSpec.isSingleValueField();
                boolean bl = isNoDictionaryColumn = !columnReader.hasDictionary();
                if (isMultiValueColumn || isNoDictionaryColumn) {
                    throw new IllegalStateException("Multi value column or no dictionary column is not supported. ( column name: " + dimensionName + ", multi value column: " + isMultiValueColumn + ", no dictionary column: " + isNoDictionaryColumn + " )");
                }
                compare = columnReader.getDictId(docId1) - columnReader.getDictId(docId2);
                if (compare == 0) continue;
                return compare;
            }
            return compare;
        }, (i, j) -> {
            int temp = sortedDocIds[i];
            sortedDocIds[i] = sortedDocIds[j];
            sortedDocIds[j] = temp;
        });
        return sortedDocIds;
    }
}

