/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.readers;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.segment.ReadMode;
import org.apache.pinot.core.data.readers.PinotSegmentColumnReader;
import org.apache.pinot.core.data.readers.sort.PinotSegmentSorter;
import org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.core.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadata;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;

public class PinotSegmentRecordReader
implements RecordReader {
    private final ImmutableSegment _immutableSegment;
    private final int _numDocs;
    private final Schema _schema;
    private final Map<String, PinotSegmentColumnReader> _columnReaderMap;
    private final int[] _docIdsInSortedColumnOrder;
    private int _nextDocId = 0;

    public PinotSegmentRecordReader(File indexDir) throws Exception {
        this(indexDir, null, null);
    }

    public PinotSegmentRecordReader(File indexDir, @Nullable Schema schema, @Nullable List<String> sortOrder) throws Exception {
        this._immutableSegment = ImmutableSegmentLoader.load(indexDir, ReadMode.mmap);
        try {
            SegmentMetadata segmentMetadata = this._immutableSegment.getSegmentMetadata();
            this._numDocs = segmentMetadata.getTotalDocs();
            if (schema == null) {
                this._schema = new SegmentMetadataImpl(indexDir).getSchema();
                Set columnNames = this._schema.getColumnNames();
                this._columnReaderMap = new HashMap<String, PinotSegmentColumnReader>(columnNames.size());
                for (String columnName : columnNames) {
                    this._columnReaderMap.put(columnName, new PinotSegmentColumnReader(this._immutableSegment, columnName));
                }
            } else {
                this._schema = schema;
                Schema segmentSchema = segmentMetadata.getSchema();
                Collection fieldSpecs = this._schema.getAllFieldSpecs();
                this._columnReaderMap = new HashMap<String, PinotSegmentColumnReader>(fieldSpecs.size());
                for (FieldSpec fieldSpec : fieldSpecs) {
                    String columnName = fieldSpec.getName();
                    FieldSpec segmentFieldSpec = segmentSchema.getFieldSpecFor(columnName);
                    Preconditions.checkState((boolean)fieldSpec.equals((Object)segmentFieldSpec), (String)"Field spec mismatch for column: %s, in the given schema: %s, in the segment schema: %s", (Object)columnName, (Object)fieldSpec, (Object)segmentFieldSpec);
                    this._columnReaderMap.put(columnName, new PinotSegmentColumnReader(this._immutableSegment, columnName));
                }
            }
            this._docIdsInSortedColumnOrder = (int[])(sortOrder != null && !sortOrder.isEmpty() ? new PinotSegmentSorter(this._numDocs, this._schema, this._columnReaderMap).getSortedDocIds(sortOrder) : null);
        }
        catch (Exception e) {
            this._immutableSegment.destroy();
            throw e;
        }
    }

    public Schema getSchema() {
        return this._schema;
    }

    public void init(File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) {
    }

    public boolean hasNext() {
        return this._nextDocId < this._numDocs;
    }

    public GenericRow next() {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) {
        reuse = this._docIdsInSortedColumnOrder == null ? this.getRecord(reuse, this._nextDocId) : this.getRecord(reuse, this._docIdsInSortedColumnOrder[this._nextDocId]);
        ++this._nextDocId;
        return reuse;
    }

    private GenericRow getRecord(GenericRow reuse, int docId) {
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            String fieldName = fieldSpec.getName();
            reuse.putValue(fieldName, this._columnReaderMap.get(fieldName).getValue(docId));
        }
        return reuse;
    }

    public void rewind() {
        this._nextDocId = 0;
    }

    public void close() throws IOException {
        for (PinotSegmentColumnReader columnReader : this._columnReaderMap.values()) {
            columnReader.close();
        }
        this._immutableSegment.destroy();
    }
}

