/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.readers;

import java.io.Closeable;
import java.io.IOException;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReaderContext;

public class PinotSegmentColumnReader
implements Closeable {
    private final ForwardIndexReader _reader;
    private final ForwardIndexReaderContext _readerContext;
    private final Dictionary _dictionary;
    private final int[] _dictIdBuffer;

    public PinotSegmentColumnReader(ImmutableSegment immutableSegment, String column) {
        DataSource dataSource = immutableSegment.getDataSource(column);
        this._reader = dataSource.getForwardIndex();
        this._readerContext = this._reader.createContext();
        this._dictionary = dataSource.getDictionary();
        this._dictIdBuffer = (int[])(this._reader.isSingleValue() ? null : new int[dataSource.getDataSourceMetadata().getMaxNumValuesPerMVEntry()]);
    }

    public boolean hasDictionary() {
        return this._dictionary != null;
    }

    public int getDictId(int docId) {
        return this._reader.getDictId(docId, this._readerContext);
    }

    public Object getValue(int docId) {
        if (this._dictionary != null) {
            if (this._reader.isSingleValue()) {
                return this._dictionary.get(this._reader.getDictId(docId, this._readerContext));
            }
            int numValues = this._reader.getDictIdMV(docId, this._dictIdBuffer, this._readerContext);
            Object[] values = new Object[numValues];
            for (int i = 0; i < numValues; ++i) {
                values[i] = this._dictionary.get(this._dictIdBuffer[i]);
            }
            return values;
        }
        assert (this._reader.isSingleValue());
        switch (this._reader.getValueType()) {
            case INT: {
                return this._reader.getInt(docId, this._readerContext);
            }
            case LONG: {
                return this._reader.getLong(docId, this._readerContext);
            }
            case FLOAT: {
                return Float.valueOf(this._reader.getFloat(docId, this._readerContext));
            }
            case DOUBLE: {
                return this._reader.getDouble(docId, this._readerContext);
            }
            case STRING: {
                return this._reader.getString(docId, this._readerContext);
            }
            case BYTES: {
                return this._reader.getBytes(docId, this._readerContext);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void close() throws IOException {
        if (this._readerContext != null) {
            this._readerContext.close();
        }
    }
}

