/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.partition;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.data.partition.PartitionFunction;

public class MurmurPartitionFunction
implements PartitionFunction {
    private static final String NAME = "Murmur";
    private final int _numPartitions;

    public MurmurPartitionFunction(int numPartitions) {
        Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (Object)"Number of partitions must be > 0");
        this._numPartitions = numPartitions;
    }

    @Override
    public int getPartition(Object valueIn) {
        String value = valueIn instanceof String ? (String)valueIn : valueIn.toString();
        return (this.murmur2(StringUtil.encodeUtf8((String)value)) & Integer.MAX_VALUE) % this._numPartitions;
    }

    @Override
    public int getNumPartitions() {
        return this._numPartitions;
    }

    public String toString() {
        return NAME;
    }

    @VisibleForTesting
    int murmur2(byte[] data) {
        return HashUtil.murmur2((byte[])data);
    }
}

