/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.partition;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.pinot.core.data.partition.PartitionFunction;

public class ByteArrayPartitionFunction
implements PartitionFunction {
    private static final String NAME = "ByteArray";
    private final int _numPartitions;

    public ByteArrayPartitionFunction(int numPartitions) {
        Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (String)"Number of partitions must be > 0, specified", (int)numPartitions);
        this._numPartitions = numPartitions;
    }

    @Override
    public int getPartition(Object valueIn) {
        return this.abs(Arrays.hashCode(valueIn.toString().getBytes())) % this._numPartitions;
    }

    @Override
    public int getNumPartitions() {
        return this._numPartitions;
    }

    public String toString() {
        return NAME;
    }

    private int abs(int n) {
        return n == Integer.MIN_VALUE ? 0 : Math.abs(n);
    }
}

