/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.server.realtime.ServerSegmentCompletionProtocolHandler;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentBuildTimeLeaseExtender {
    private static final int MAX_NUM_ATTEMPTS = 3;
    private static final int EXTRA_TIME_SECONDS = 120;
    private static final int REPEAT_REQUEST_PERIOD_SEC = 108;
    private static Logger LOGGER = LoggerFactory.getLogger(SegmentBuildTimeLeaseExtender.class);
    private static final Map<String, SegmentBuildTimeLeaseExtender> INSTANCE_TO_LEASE_EXTENDER = new HashMap<String, SegmentBuildTimeLeaseExtender>(1);
    private ScheduledExecutorService _executor;
    private final Map<String, Future> _segmentToFutureMap = new ConcurrentHashMap<String, Future>();
    private final String _instanceId;
    private final ServerSegmentCompletionProtocolHandler _protocolHandler;

    public static SegmentBuildTimeLeaseExtender getLeaseExtender(String instanceId) {
        return INSTANCE_TO_LEASE_EXTENDER.get(instanceId);
    }

    public static synchronized SegmentBuildTimeLeaseExtender create(String instanceId, ServerMetrics serverMetrics, String tableNameWithType) {
        SegmentBuildTimeLeaseExtender leaseExtender = INSTANCE_TO_LEASE_EXTENDER.get(instanceId);
        if (leaseExtender != null) {
            LOGGER.warn("Instance already exists");
        } else {
            leaseExtender = new SegmentBuildTimeLeaseExtender(instanceId, serverMetrics, tableNameWithType);
            INSTANCE_TO_LEASE_EXTENDER.put(instanceId, leaseExtender);
        }
        return leaseExtender;
    }

    private SegmentBuildTimeLeaseExtender(String instanceId, ServerMetrics serverMetrics, String tableNameWithType) {
        this._instanceId = instanceId;
        this._protocolHandler = new ServerSegmentCompletionProtocolHandler(serverMetrics, tableNameWithType);
        this._executor = new ScheduledThreadPoolExecutor(1);
    }

    public void shutDown() {
        if (this._executor != null) {
            this._executor.shutdownNow();
            this._executor = null;
        }
        this._segmentToFutureMap.clear();
    }

    public void addSegment(String segmentId, long initialBuildTimeMs, StreamPartitionMsgOffset offset) {
        long initialDelayMs = initialBuildTimeMs * 9L / 10L;
        SegmentCompletionProtocol.Request.Params reqParams = new SegmentCompletionProtocol.Request.Params();
        reqParams.withStreamPartitionMsgOffset(offset.toString()).withSegmentName(segmentId).withExtraTimeSec(120).withInstanceId(this._instanceId);
        ScheduledFuture<?> future = this._executor.scheduleWithFixedDelay(new LeaseExtender(reqParams), initialDelayMs, 108000L, TimeUnit.MILLISECONDS);
        this._segmentToFutureMap.put(segmentId, future);
    }

    public void removeSegment(String segmentId) {
        boolean cancelled;
        Future future = this._segmentToFutureMap.get(segmentId);
        if (future != null && !(cancelled = future.cancel(true))) {
            LOGGER.warn("Task could not be cancelled for {}" + segmentId);
        }
        this._segmentToFutureMap.remove(segmentId);
    }

    private class LeaseExtender
    implements Runnable {
        private final SegmentCompletionProtocol.Request.Params _params;

        private LeaseExtender(SegmentCompletionProtocol.Request.Params params) {
            this._params = params;
        }

        @Override
        public void run() {
            int nAttempts = 0;
            SegmentCompletionProtocol.ControllerResponseStatus status = SegmentCompletionProtocol.ControllerResponseStatus.NOT_SENT;
            String segmentId = this._params.getSegmentName();
            while (status != SegmentCompletionProtocol.ControllerResponseStatus.PROCESSED && nAttempts < 3) {
                try {
                    SegmentCompletionProtocol.Response response = SegmentBuildTimeLeaseExtender.this._protocolHandler.extendBuildTime(this._params);
                    status = response.getStatus();
                }
                catch (Exception e) {
                    LOGGER.warn("Exception trying to send lease renewal for {}", (Object)segmentId);
                }
                if (status == SegmentCompletionProtocol.ControllerResponseStatus.PROCESSED) continue;
                Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
                LOGGER.warn("Retrying lease extension for {} because controller status {}", (Object)segmentId, (Object)status.toString());
                ++nAttempts;
            }
            if (nAttempts >= 3) {
                LOGGER.error("Failed to send lease extension for {}", (Object)segmentId);
            }
        }
    }
}

