/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metadata.segment.LLCRealtimeSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.core.data.manager.realtime.RealtimeSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.RealtimeTableDataManager;
import org.apache.pinot.core.data.manager.realtime.SegmentBuildTimeLeaseExtender;
import org.apache.pinot.core.data.manager.realtime.SegmentCommitter;
import org.apache.pinot.core.data.manager.realtime.SegmentCommitterFactory;
import org.apache.pinot.core.data.partition.PartitionFunctionFactory;
import org.apache.pinot.core.data.recordtransformer.CompositeTransformer;
import org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.core.indexsegment.mutable.MutableSegment;
import org.apache.pinot.core.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.core.realtime.converter.RealtimeSegmentConverter;
import org.apache.pinot.core.realtime.impl.RealtimeSegmentConfig;
import org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.core.segment.store.SegmentDirectoryPaths;
import org.apache.pinot.core.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.core.util.IngestionUtils;
import org.apache.pinot.server.realtime.ServerSegmentCompletionProtocolHandler;
import org.apache.pinot.spi.config.table.ColumnPartitionConfig;
import org.apache.pinot.spi.config.table.CompletionConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.MessageBatch;
import org.apache.pinot.spi.stream.PartitionLevelConsumer;
import org.apache.pinot.spi.stream.PartitionLevelStreamConfig;
import org.apache.pinot.spi.stream.PermanentConsumerException;
import org.apache.pinot.spi.stream.RowMetadata;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamConsumerFactory;
import org.apache.pinot.spi.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.spi.stream.StreamDecoderProvider;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.apache.pinot.spi.stream.StreamMetadataProvider;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffsetFactory;
import org.apache.pinot.spi.stream.TransientConsumerException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLRealtimeSegmentDataManager
extends RealtimeSegmentDataManager {
    private static int MINIMUM_CONSUME_TIME_MINUTES = 10;
    private static final long TIME_THRESHOLD_FOR_LOG_MINUTES = 1L;
    private static final long TIME_EXTENSION_ON_EMPTY_SEGMENT_HOURS = 1L;
    private static final int MSG_COUNT_THRESHOLD_FOR_LOG = 100000;
    private static final int BUILD_TIME_LEASE_SECONDS = 30;
    private static final int MAX_CONSECUTIVE_ERROR_COUNT = 5;
    private final LLCRealtimeSegmentZKMetadata _segmentZKMetadata;
    private final TableConfig _tableConfig;
    private final RealtimeTableDataManager _realtimeTableDataManager;
    private final StreamMessageDecoder _messageDecoder;
    private final int _segmentMaxRowCount;
    private final String _resourceDataDir;
    private final IndexLoadingConfig _indexLoadingConfig;
    private final Schema _schema;
    private final Semaphore _partitionConsumerSemaphore;
    private final AtomicBoolean _acquiredConsumerSemaphore;
    private final String _metricKeyName;
    private final ServerMetrics _serverMetrics;
    private final MutableSegmentImpl _realtimeSegment;
    private StreamPartitionMsgOffset _currentOffset;
    private volatile State _state;
    private volatile int _numRowsConsumed = 0;
    private volatile int _numRowsIndexed = 0;
    private volatile int _numRowsErrored = 0;
    private volatile int consecutiveErrorCount = 0;
    private long _startTimeMs = 0L;
    private final String _segmentNameStr;
    private final SegmentVersion _segmentVersion;
    private final SegmentBuildTimeLeaseExtender _leaseExtender;
    private SegmentBuildDescriptor _segmentBuildDescriptor;
    private StreamConsumerFactory _streamConsumerFactory;
    private StreamPartitionMsgOffsetFactory _streamPartitionMsgOffsetFactory;
    private volatile long _consumeEndTime = 0L;
    private StreamPartitionMsgOffset _finalOffset;
    private volatile boolean _shouldStop = false;
    private static final int MAX_TIME_FOR_CONSUMING_TO_ONLINE_IN_SECONDS = 31;
    private Thread _consumerThread;
    private final String _streamTopic;
    private final int _streamPartitionId;
    final String _clientId;
    private final LLCSegmentName _llcSegmentName;
    private final RecordTransformer _recordTransformer;
    private PartitionLevelConsumer _partitionLevelConsumer = null;
    private StreamMetadataProvider _streamMetadataProvider = null;
    private final File _resourceTmpDir;
    private final String _tableNameWithType;
    private final List<String> _invertedIndexColumns;
    private final List<String> _textIndexColumns;
    private final List<String> _noDictionaryColumns;
    private final List<String> _varLengthDictionaryColumns;
    private final String _sortedColumn;
    private Logger segmentLogger;
    private final String _tableStreamName;
    private final PinotDataBufferMemoryManager _memoryManager;
    private AtomicLong _lastUpdatedRowsIndexed = new AtomicLong(0L);
    private final String _instanceId;
    private final ServerSegmentCompletionProtocolHandler _protocolHandler;
    private final long _consumeStartTime;
    private final StreamPartitionMsgOffset _startOffset;
    private final PartitionLevelStreamConfig _partitionLevelStreamConfig;
    private long _lastLogTime = 0L;
    private int _lastConsumedCount = 0;
    private String _stopReason = null;
    private final Semaphore _segBuildSemaphore;
    private final boolean _isOffHeap;
    private final boolean _nullHandlingEnabled;
    private final SegmentCommitterFactory _segmentCommitterFactory;

    private boolean endCriteriaReached() {
        Preconditions.checkState((boolean)this._state.shouldConsume(), (String)"Incorrect state %s", (Object)((Object)this._state));
        long now = this.now();
        switch (this._state) {
            case INITIAL_CONSUMING: {
                if (now >= this._consumeEndTime) {
                    if (this._realtimeSegment.getNumDocsIndexed() == 0) {
                        this.segmentLogger.info("No events came in, extending time by {} hours", (Object)1L);
                        this._consumeEndTime += TimeUnit.HOURS.toMillis(1L);
                        return false;
                    }
                    this.segmentLogger.info("Stopping consumption due to time limit start={} now={} numRowsConsumed={} numRowsIndexed={}", new Object[]{this._startTimeMs, now, this._numRowsConsumed, this._numRowsIndexed});
                    this._stopReason = "timeLimit";
                    return true;
                }
                if (this._numRowsIndexed >= this._segmentMaxRowCount) {
                    this.segmentLogger.info("Stopping consumption due to row limit nRows={} numRowsIndexed={}, numRowsConsumed={}", new Object[]{this._numRowsIndexed, this._numRowsConsumed, this._segmentMaxRowCount});
                    this._stopReason = "rowLimit";
                    return true;
                }
                return false;
            }
            case CATCHING_UP: {
                this._stopReason = null;
                if (this._currentOffset.compareTo((Object)this._finalOffset) == 0) {
                    this.segmentLogger.info("Caught up to offset={}, state={}", (Object)this._finalOffset, (Object)this._state.toString());
                    return true;
                }
                if (this._currentOffset.compareTo((Object)this._finalOffset) > 0) {
                    this.segmentLogger.error("Offset higher in state={}, current={}, final={}", new Object[]{this._state.toString(), this._currentOffset, this._finalOffset});
                    throw new RuntimeException("Past max offset");
                }
                return false;
            }
            case CONSUMING_TO_ONLINE: {
                if (this._currentOffset.compareTo((Object)this._finalOffset) == 0) {
                    this.segmentLogger.info("Caught up to offset={}, state={}", (Object)this._finalOffset, (Object)this._state.toString());
                    return true;
                }
                if (now >= this._consumeEndTime) {
                    this.segmentLogger.info("Past max time budget: offset={}, state={}", (Object)this._currentOffset, (Object)this._state.toString());
                    return true;
                }
                if (this._currentOffset.compareTo((Object)this._finalOffset) > 0) {
                    this.segmentLogger.error("Offset higher in state={}, current={}, final={}", new Object[]{this._state.toString(), this._currentOffset, this._finalOffset});
                    throw new RuntimeException("Past max offset");
                }
                return false;
            }
        }
        this.segmentLogger.error("Illegal state {}" + this._state.toString());
        throw new RuntimeException("Illegal state to consume");
    }

    private void handleTransientStreamErrors(Exception e) throws Exception {
        ++this.consecutiveErrorCount;
        if (this.consecutiveErrorCount > 5) {
            this.segmentLogger.warn("Stream transient exception when fetching messages, stopping consumption after {} attempts", (Object)this.consecutiveErrorCount, (Object)e);
            throw e;
        }
        this.segmentLogger.warn("Stream transient exception when fetching messages, retrying (count={})", (Object)this.consecutiveErrorCount, (Object)e);
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.makeStreamConsumer("Too many transient errors");
    }

    protected boolean consumeLoop() throws Exception {
        this._numRowsErrored = 0;
        long idlePipeSleepTimeMillis = 100L;
        long maxIdleCountBeforeStatUpdate = 180000L / (100L + (long)this._partitionLevelStreamConfig.getFetchTimeoutMillis());
        StreamPartitionMsgOffset lastUpdatedOffset = this._streamPartitionMsgOffsetFactory.create(this._currentOffset);
        long consecutiveIdleCount = 0L;
        this.removeSegmentFile();
        this.segmentLogger.info("Starting consumption loop start offset {}, finalOffset {}", (Object)this._currentOffset, (Object)this._finalOffset);
        while (!this._shouldStop && !this.endCriteriaReached()) {
            MessageBatch messageBatch;
            try {
                messageBatch = this._partitionLevelConsumer.fetchMessages(this._currentOffset, null, this._partitionLevelStreamConfig.getFetchTimeoutMillis());
                this.consecutiveErrorCount = 0;
            }
            catch (TimeoutException e) {
                this.handleTransientStreamErrors(e);
                continue;
            }
            catch (TransientConsumerException e) {
                this.handleTransientStreamErrors((Exception)((Object)e));
                continue;
            }
            catch (PermanentConsumerException e) {
                this.segmentLogger.warn("Permanent exception from stream when fetching messages, stopping consumption", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this.handleTransientStreamErrors(e);
                continue;
            }
            this.processStreamEvents(messageBatch, 100L);
            if (this._currentOffset.compareTo((Object)lastUpdatedOffset) != 0) {
                consecutiveIdleCount = 0L;
                this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 1L);
                lastUpdatedOffset = this._streamPartitionMsgOffsetFactory.create(this._currentOffset);
                continue;
            }
            if (++consecutiveIdleCount <= maxIdleCountBeforeStatUpdate) continue;
            this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 1L);
            consecutiveIdleCount = 0L;
            this.makeStreamConsumer("Idle for too long");
        }
        if (this._numRowsErrored > 0) {
            this._serverMetrics.addMeteredTableValue(this._metricKeyName, (AbstractMetrics.Meter)ServerMeter.ROWS_WITH_ERRORS, (long)this._numRowsErrored);
            this._serverMetrics.addMeteredTableValue(this._tableStreamName, (AbstractMetrics.Meter)ServerMeter.ROWS_WITH_ERRORS, (long)this._numRowsErrored);
        }
        return true;
    }

    private void processStreamEvents(MessageBatch messagesAndOffsets, long idlePipeSleepTimeMillis) {
        Meter realtimeRowsConsumedMeter = null;
        Meter realtimeRowsDroppedMeter = null;
        int indexedMessageCount = 0;
        int streamMessageCount = 0;
        boolean canTakeMore = true;
        GenericRow reuse = new GenericRow();
        for (int index = 0; index < messagesAndOffsets.getMessageCount() && !this._shouldStop && !this.endCriteriaReached(); ++index) {
            block12: {
                if (!canTakeMore) {
                    this.segmentLogger.error("Buffer full with {} rows consumed (row limit {}, indexed {})", new Object[]{this._numRowsConsumed, this._numRowsIndexed, this._segmentMaxRowCount});
                    throw new RuntimeException("Realtime segment full");
                }
                reuse.clear();
                RowMetadata msgMetadata = messagesAndOffsets.getMetadataAtIndex(index);
                GenericRow decodedRow = this._messageDecoder.decode(messagesAndOffsets.getMessageAtIndex(index), messagesAndOffsets.getMessageOffsetAtIndex(index), messagesAndOffsets.getMessageLengthAtIndex(index), reuse);
                if (decodedRow != null) {
                    try {
                        if (decodedRow.getValue("$MULTIPLE_RECORDS_KEY$") != null) {
                            for (Object singleRow : (Collection)decodedRow.getValue("$MULTIPLE_RECORDS_KEY$")) {
                                GenericRow transformedRow = this._recordTransformer.transform((GenericRow)singleRow);
                                if (transformedRow != null && IngestionUtils.shouldIngestRow(transformedRow)) {
                                    realtimeRowsConsumedMeter = this._serverMetrics.addMeteredTableValue(this._metricKeyName, (AbstractMetrics.Meter)ServerMeter.REALTIME_ROWS_CONSUMED, 1L, realtimeRowsConsumedMeter);
                                    ++indexedMessageCount;
                                    canTakeMore = this._realtimeSegment.index(transformedRow, msgMetadata);
                                    continue;
                                }
                                realtimeRowsDroppedMeter = this._serverMetrics.addMeteredTableValue(this._metricKeyName, (AbstractMetrics.Meter)ServerMeter.INVALID_REALTIME_ROWS_DROPPED, 1L, realtimeRowsDroppedMeter);
                            }
                            break block12;
                        }
                        GenericRow transformedRow = this._recordTransformer.transform(decodedRow);
                        if (transformedRow != null && IngestionUtils.shouldIngestRow(transformedRow)) {
                            realtimeRowsConsumedMeter = this._serverMetrics.addMeteredTableValue(this._metricKeyName, (AbstractMetrics.Meter)ServerMeter.REALTIME_ROWS_CONSUMED, 1L, realtimeRowsConsumedMeter);
                            ++indexedMessageCount;
                            canTakeMore = this._realtimeSegment.index(transformedRow, msgMetadata);
                            break block12;
                        }
                        realtimeRowsDroppedMeter = this._serverMetrics.addMeteredTableValue(this._metricKeyName, (AbstractMetrics.Meter)ServerMeter.INVALID_REALTIME_ROWS_DROPPED, 1L, realtimeRowsDroppedMeter);
                    }
                    catch (Exception e) {
                        this.segmentLogger.error("Caught exception while transforming the record: {}", (Object)decodedRow, (Object)e);
                        ++this._numRowsErrored;
                    }
                } else {
                    realtimeRowsDroppedMeter = this._serverMetrics.addMeteredTableValue(this._metricKeyName, (AbstractMetrics.Meter)ServerMeter.INVALID_REALTIME_ROWS_DROPPED, 1L, realtimeRowsDroppedMeter);
                }
            }
            this._currentOffset = messagesAndOffsets.getNextStreamParitionMsgOffsetAtIndex(index);
            this._numRowsIndexed = this._realtimeSegment.getNumDocsIndexed();
            ++this._numRowsConsumed;
            ++streamMessageCount;
        }
        this.updateCurrentDocumentCountMetrics();
        if (streamMessageCount != 0) {
            this.segmentLogger.debug("Indexed {} messages ({} messages read from stream) current offset {}", new Object[]{indexedMessageCount, streamMessageCount, this._currentOffset});
        } else {
            Uninterruptibles.sleepUninterruptibly((long)idlePipeSleepTimeMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    private CommonConstants.Segment.Realtime.CompletionMode getSegmentCompletionMode() {
        CompletionConfig completionConfig = this._tableConfig.getValidationConfig().getCompletionConfig();
        if (completionConfig != null && CommonConstants.Segment.Realtime.CompletionMode.DOWNLOAD.toString().equalsIgnoreCase(completionConfig.getCompletionMode())) {
            return CommonConstants.Segment.Realtime.CompletionMode.DOWNLOAD;
        }
        return CommonConstants.Segment.Realtime.CompletionMode.DEFAULT;
    }

    @VisibleForTesting
    protected StreamPartitionMsgOffset extractOffset(SegmentCompletionProtocol.Response response) {
        if (response.getStreamPartitionMsgOffset() != null) {
            return this._streamPartitionMsgOffsetFactory.create(response.getStreamPartitionMsgOffset());
        }
        return this._streamPartitionMsgOffsetFactory.create(Long.toString(response.getOffset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildSegmentForCommit(long buildTimeLeaseMs) {
        try {
            File segmentTarFile;
            if (this._segmentBuildDescriptor != null && this._segmentBuildDescriptor.getOffset().compareTo((Object)this._currentOffset) == 0 && (segmentTarFile = this._segmentBuildDescriptor.getSegmentTarFile()) != null && segmentTarFile.exists()) {
                return;
            }
            this.removeSegmentFile();
            if (buildTimeLeaseMs <= 0L) {
                buildTimeLeaseMs = this._segBuildSemaphore == null ? (long)SegmentCompletionProtocol.getDefaultMaxSegmentCommitTimeSeconds() * 1000L : 30000L;
            }
            this._leaseExtender.addSegment(this._segmentNameStr, buildTimeLeaseMs, this._currentOffset);
            this._segmentBuildDescriptor = this.buildSegmentInternal(true);
        }
        finally {
            this._leaseExtender.removeSegment(this._segmentNameStr);
        }
    }

    @VisibleForTesting
    protected StreamPartitionMsgOffset getCurrentOffset() {
        return this._currentOffset;
    }

    @VisibleForTesting
    protected SegmentBuildDescriptor getSegmentBuildDescriptor() {
        return this._segmentBuildDescriptor;
    }

    @VisibleForTesting
    protected Semaphore getPartitionConsumerSemaphore() {
        return this._partitionConsumerSemaphore;
    }

    @VisibleForTesting
    protected AtomicBoolean getAcquiredConsumerSemaphore() {
        return this._acquiredConsumerSemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SegmentBuildDescriptor buildSegmentInternal(boolean forCommit) {
        long segmentSizeBytes;
        File indexDir;
        File dataDir;
        long waitTimeMillis;
        long buildTimeMillis;
        this.closeKafkaConsumers();
        try {
            long startTimeMillis = this.now();
            if (this._segBuildSemaphore != null) {
                this.segmentLogger.info("Waiting to acquire semaphore for building segment");
                this._segBuildSemaphore.acquire();
            }
            this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, 1L);
            long lockAcquireTimeMillis = this.now();
            File tempSegmentFolder = new File(this._resourceTmpDir, "tmp-" + this._segmentNameStr + "-" + this.now());
            RealtimeSegmentConverter converter = new RealtimeSegmentConverter(this._realtimeSegment, tempSegmentFolder.getAbsolutePath(), this._schema, this._tableNameWithType, this._tableConfig, this._segmentZKMetadata.getSegmentName(), this._sortedColumn, this._invertedIndexColumns, this._textIndexColumns, this._noDictionaryColumns, this._varLengthDictionaryColumns, this._nullHandlingEnabled);
            this.segmentLogger.info("Trying to build segment");
            try {
                converter.build(this._segmentVersion, this._serverMetrics);
            }
            catch (Exception e) {
                this.segmentLogger.error("Could not build segment", (Throwable)e);
                FileUtils.deleteQuietly((File)tempSegmentFolder);
                SegmentBuildDescriptor segmentBuildDescriptor = null;
                if (this._segBuildSemaphore != null) {
                    this._segBuildSemaphore.release();
                }
                this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
                return segmentBuildDescriptor;
            }
            buildTimeMillis = this.now() - lockAcquireTimeMillis;
            waitTimeMillis = lockAcquireTimeMillis - startTimeMillis;
            this.segmentLogger.info("Successfully built segment in {} ms, after lockWaitTime {} ms", (Object)buildTimeMillis, (Object)waitTimeMillis);
            dataDir = new File(this._resourceDataDir);
            indexDir = new File(dataDir, this._segmentNameStr);
            FileUtils.deleteQuietly((File)indexDir);
            File[] tempFiles = tempSegmentFolder.listFiles();
            assert (tempFiles != null);
            File tempIndexDir = tempFiles[0];
            try {
                FileUtils.moveDirectory((File)tempIndexDir, (File)indexDir);
            }
            catch (IOException e) {
                this.segmentLogger.error("Caught exception while moving index directory from: {} to: {}", new Object[]{tempIndexDir, indexDir, e});
                SegmentBuildDescriptor segmentBuildDescriptor = null;
                if (this._segBuildSemaphore != null) {
                    this._segBuildSemaphore.release();
                }
                this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
                return segmentBuildDescriptor;
            }
            finally {
                FileUtils.deleteQuietly((File)tempSegmentFolder);
            }
            segmentSizeBytes = FileUtils.sizeOfDirectory((File)indexDir);
        }
        catch (InterruptedException e) {
            this.segmentLogger.error("Interrupted while waiting for semaphore");
            SegmentBuildDescriptor segmentBuildDescriptor = null;
            return segmentBuildDescriptor;
        }
        this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_CREATION_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(buildTimeMillis));
        this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_CREATION_WAIT_TIME_SECONDS, TimeUnit.MILLISECONDS.toSeconds(waitTimeMillis));
        if (!forCommit) return new SegmentBuildDescriptor(null, null, this._currentOffset, buildTimeMillis, waitTimeMillis, segmentSizeBytes);
        File segmentTarFile = new File(dataDir, this._segmentNameStr + ".tar.gz");
        try {
            TarGzCompressionUtils.createTarGzFile((File)indexDir, (File)segmentTarFile);
        }
        catch (IOException e) {
            this.segmentLogger.error("Caught exception while taring index directory from: {} to: {}", new Object[]{indexDir, segmentTarFile, e});
            SegmentBuildDescriptor segmentBuildDescriptor = null;
            if (this._segBuildSemaphore != null) {
                this._segBuildSemaphore.release();
            }
            this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
            return segmentBuildDescriptor;
        }
        File metadataFile = SegmentDirectoryPaths.findMetadataFile(indexDir);
        if (metadataFile == null) {
            this.segmentLogger.error("Failed to find file: {} under index directory: {}", (Object)"metadata.properties", (Object)indexDir);
            return null;
        }
        File creationMetaFile = SegmentDirectoryPaths.findCreationMetaFile(indexDir);
        if (creationMetaFile == null) {
            this.segmentLogger.error("Failed to find file: {} under index directory: {}", (Object)"creation.meta", (Object)indexDir);
            return null;
        }
        HashMap<String, File> metadataFiles = new HashMap<String, File>();
        metadataFiles.put("metadata.properties", metadataFile);
        metadataFiles.put("creation.meta", creationMetaFile);
        return new SegmentBuildDescriptor(segmentTarFile, metadataFiles, this._currentOffset, buildTimeMillis, waitTimeMillis, segmentSizeBytes);
        finally {
            if (this._segBuildSemaphore != null) {
                this._segBuildSemaphore.release();
            }
            this._serverMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
        }
    }

    protected boolean commitSegment(String controllerVipUrl, boolean isSplitCommit) {
        File segmentTarFile = this._segmentBuildDescriptor.getSegmentTarFile();
        if (segmentTarFile == null || !segmentTarFile.exists()) {
            throw new RuntimeException("Segment file does not exist: " + segmentTarFile);
        }
        SegmentCompletionProtocol.Response commitResponse = this.commit(controllerVipUrl, isSplitCommit);
        if (!commitResponse.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_SUCCESS)) {
            return false;
        }
        this._realtimeTableDataManager.replaceLLSegment(this._segmentNameStr, this._indexLoadingConfig);
        this.removeSegmentFile();
        return true;
    }

    protected SegmentCompletionProtocol.Response commit(String controllerVipUrl, boolean isSplitCommit) {
        SegmentCommitter segmentCommitter;
        SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
        params.withSegmentName(this._segmentNameStr).withStreamPartitionMsgOffset(this._currentOffset.toString()).withNumRows(this._numRowsConsumed).withInstanceId(this._instanceId).withBuildTimeMillis(this._segmentBuildDescriptor.getBuildTimeMillis()).withSegmentSizeBytes(this._segmentBuildDescriptor.getSegmentSizeBytes()).withWaitTimeMillis(this._segmentBuildDescriptor.getWaitTimeMillis());
        if (this._isOffHeap) {
            params.withMemoryUsedBytes(this._memoryManager.getTotalAllocatedBytes());
        }
        try {
            segmentCommitter = this._segmentCommitterFactory.createSegmentCommitter(isSplitCommit, params, controllerVipUrl);
        }
        catch (URISyntaxException e) {
            this.segmentLogger.error("Failed to create a segment committer: ", (Throwable)e);
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return segmentCommitter.commit(this._segmentBuildDescriptor);
    }

    protected boolean buildSegmentAndReplace() {
        SegmentBuildDescriptor descriptor = this.buildSegmentInternal(false);
        if (descriptor == null) {
            return false;
        }
        this._realtimeTableDataManager.replaceLLSegment(this._segmentNameStr, this._indexLoadingConfig);
        return true;
    }

    private void closeKafkaConsumers() {
        this.closePartitionLevelConsumer();
        this.closeStreamMetadataProvider();
        if (this._acquiredConsumerSemaphore.compareAndSet(true, false)) {
            this._partitionConsumerSemaphore.release();
        }
    }

    private void closePartitionLevelConsumer() {
        try {
            this._partitionLevelConsumer.close();
        }
        catch (Exception e) {
            this.segmentLogger.warn("Could not close stream consumer", (Throwable)e);
        }
    }

    private void closeStreamMetadataProvider() {
        try {
            this._streamMetadataProvider.close();
        }
        catch (Exception e) {
            this.segmentLogger.warn("Could not close stream metadata provider", (Throwable)e);
        }
    }

    protected void hold() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            this.segmentLogger.warn("Interrupted while holding");
        }
    }

    protected void postStopConsumedMsg(String reason) {
        do {
            SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
            params.withStreamPartitionMsgOffset(this._currentOffset.toString()).withReason(reason).withSegmentName(this._segmentNameStr).withInstanceId(this._instanceId);
            SegmentCompletionProtocol.Response response = this._protocolHandler.segmentStoppedConsuming(params);
            if (response.getStatus() == SegmentCompletionProtocol.ControllerResponseStatus.PROCESSED) {
                this.segmentLogger.info("Got response {}", (Object)response.toJsonString());
                break;
            }
            Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
            this.segmentLogger.info("Retrying after response {}", (Object)response.toJsonString());
        } while (!this._shouldStop);
    }

    protected SegmentCompletionProtocol.Response postSegmentConsumedMsg() {
        SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
        params.withStreamPartitionMsgOffset(this._currentOffset.toString()).withSegmentName(this._segmentNameStr).withReason(this._stopReason).withNumRows(this._numRowsConsumed).withInstanceId(this._instanceId);
        if (this._isOffHeap) {
            params.withMemoryUsedBytes(this._memoryManager.getTotalAllocatedBytes());
        }
        return this._protocolHandler.segmentConsumed(params);
    }

    private void removeSegmentFile() {
        if (this._segmentBuildDescriptor != null) {
            this._segmentBuildDescriptor.deleteSegmentFile();
            this._segmentBuildDescriptor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void goOnlineFromConsuming(RealtimeSegmentZKMetadata metadata) throws InterruptedException {
        this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        try {
            LLCRealtimeSegmentZKMetadata llcMetadata = (LLCRealtimeSegmentZKMetadata)metadata;
            this.removeSegmentFile();
            this._leaseExtender.removeSegment(this._segmentNameStr);
            StreamPartitionMsgOffset endOffset = this._streamPartitionMsgOffsetFactory.create(llcMetadata.getEndOffset());
            this.segmentLogger.info("State: {}, transitioning from CONSUMING to ONLINE (startOffset: {}, endOffset: {})", new Object[]{this._state.toString(), this._startOffset, endOffset});
            this.stop();
            this.segmentLogger.info("Consumer thread stopped in state {}", (Object)this._state.toString());
            switch (this._state) {
                case COMMITTED: 
                case RETAINED: {
                    this.segmentLogger.info("State {}. Nothing to do", (Object)this._state.toString());
                    return;
                }
                case DISCARDED: 
                case ERROR: {
                    this.segmentLogger.info("State {}. Downloading to replace", (Object)this._state.toString());
                    this.downloadSegmentAndReplace(llcMetadata);
                    return;
                }
                case INITIAL_CONSUMING: 
                case CATCHING_UP: 
                case HOLDING: {
                    CommonConstants.Segment.Realtime.CompletionMode segmentCompletionMode = this.getSegmentCompletionMode();
                    switch (segmentCompletionMode) {
                        case DOWNLOAD: {
                            this.segmentLogger.info("State {}. CompletionMode {}. Downloading to replace", (Object)this._state.toString(), (Object)segmentCompletionMode);
                            this.downloadSegmentAndReplace(llcMetadata);
                            return;
                        }
                        case DEFAULT: {
                            if (this._currentOffset.compareTo((Object)endOffset) > 0) {
                                this.segmentLogger.warn("Current offset {} ahead of the offset in zk {}. Downloading to replace", (Object)this._currentOffset, (Object)endOffset);
                                this.downloadSegmentAndReplace(llcMetadata);
                                return;
                            }
                            if (this._currentOffset.compareTo((Object)endOffset) == 0) {
                                this.segmentLogger.info("Current offset {} matches offset in zk {}. Replacing segment", (Object)this._currentOffset, (Object)endOffset);
                                this.buildSegmentAndReplace();
                                return;
                            }
                            this.segmentLogger.info("Attempting to catch up from offset {} to {} ", (Object)this._currentOffset, (Object)endOffset);
                            boolean success = this.catchupToFinalOffset(endOffset, TimeUnit.MILLISECONDS.convert(31L, TimeUnit.SECONDS));
                            if (success) {
                                this.segmentLogger.info("Caught up to offset {}", (Object)this._currentOffset);
                                this.buildSegmentAndReplace();
                                return;
                            }
                            this.segmentLogger.info("Could not catch up to offset (current = {}). Downloading to replace", (Object)this._currentOffset);
                            this.downloadSegmentAndReplace(llcMetadata);
                        }
                    }
                    return;
                }
                default: {
                    this.segmentLogger.info("Downloading to replace segment while in state {}", (Object)this._state.toString());
                    this.downloadSegmentAndReplace(llcMetadata);
                    return;
                }
            }
        }
        catch (Exception e) {
            Utils.rethrowException((Throwable)e);
            return;
        }
        finally {
            this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        }
    }

    protected void downloadSegmentAndReplace(LLCRealtimeSegmentZKMetadata metadata) {
        this.closeKafkaConsumers();
        this._realtimeTableDataManager.downloadAndReplaceSegment(this._segmentNameStr, metadata, this._indexLoadingConfig, this._tableConfig);
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean catchupToFinalOffset(StreamPartitionMsgOffset endOffset, long timeoutMs) {
        this._finalOffset = endOffset;
        this._consumeEndTime = this.now() + timeoutMs;
        this._state = State.CONSUMING_TO_ONLINE;
        this._shouldStop = false;
        try {
            this.consumeLoop();
        }
        catch (Exception e) {
            this.segmentLogger.warn("Exception when catching up to final offset", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this._serverMetrics.setValueOfTableGauge(this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        }
        if (this._currentOffset.compareTo((Object)endOffset) != 0) {
            this.segmentLogger.error("Could not consume up to {} (current offset {})", (Object)endOffset, (Object)this._currentOffset);
            return false;
        }
        return true;
    }

    @Override
    public void destroy() {
        try {
            this.stop();
        }
        catch (InterruptedException e) {
            this.segmentLogger.error("Could not stop consumer thread");
        }
        this._realtimeSegment.destroy();
        this.closeKafkaConsumers();
    }

    protected void start() {
        this._consumerThread = new Thread((Runnable)new PartitionConsumer(), this._segmentNameStr);
        this.segmentLogger.info("Created new consumer thread {} for {}", (Object)this._consumerThread, (Object)this.toString());
        this._consumerThread.start();
    }

    public void stop() throws InterruptedException {
        this._shouldStop = true;
        if (Thread.currentThread() != this._consumerThread) {
            Uninterruptibles.joinUninterruptibly((Thread)this._consumerThread, (long)10L, (TimeUnit)TimeUnit.MINUTES);
            if (this._consumerThread.isAlive()) {
                this.segmentLogger.warn("Failed to stop consumer thread within 10 minutes");
            }
        }
    }

    public LLRealtimeSegmentDataManager(RealtimeSegmentZKMetadata segmentZKMetadata, TableConfig tableConfig, RealtimeTableDataManager realtimeTableDataManager, String resourceDataDir, IndexLoadingConfig indexLoadingConfig, Schema schema, LLCSegmentName llcSegmentName, Semaphore partitionConsumerSemaphore, ServerMetrics serverMetrics, @Nullable PartitionUpsertMetadataManager partitionUpsertMetadataManager) {
        long now;
        this._segBuildSemaphore = realtimeTableDataManager.getSegmentBuildSemaphore();
        this._segmentZKMetadata = (LLCRealtimeSegmentZKMetadata)segmentZKMetadata;
        this._tableConfig = tableConfig;
        this._tableNameWithType = this._tableConfig.getTableName();
        this._realtimeTableDataManager = realtimeTableDataManager;
        this._resourceDataDir = resourceDataDir;
        this._indexLoadingConfig = indexLoadingConfig;
        this._schema = schema;
        this._serverMetrics = serverMetrics;
        this._segmentVersion = indexLoadingConfig.getSegmentVersion();
        this._instanceId = this._realtimeTableDataManager.getServerInstance();
        this._leaseExtender = SegmentBuildTimeLeaseExtender.getLeaseExtender(this._instanceId);
        this._protocolHandler = new ServerSegmentCompletionProtocolHandler(this._serverMetrics, this._tableNameWithType);
        String timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        IndexingConfig indexingConfig = this._tableConfig.getIndexingConfig();
        this._partitionLevelStreamConfig = new PartitionLevelStreamConfig(this._tableNameWithType, indexingConfig.getStreamConfigs());
        this._streamConsumerFactory = StreamConsumerFactoryProvider.create((StreamConfig)this._partitionLevelStreamConfig);
        this._streamPartitionMsgOffsetFactory = StreamConsumerFactoryProvider.create((StreamConfig)this._partitionLevelStreamConfig).createStreamMsgOffsetFactory();
        this._streamTopic = this._partitionLevelStreamConfig.getTopicName();
        this._segmentNameStr = this._segmentZKMetadata.getSegmentName();
        this._llcSegmentName = llcSegmentName;
        this._streamPartitionId = this._llcSegmentName.getPartitionId();
        this._partitionConsumerSemaphore = partitionConsumerSemaphore;
        this._acquiredConsumerSemaphore = new AtomicBoolean(false);
        this._metricKeyName = this._tableNameWithType + "-" + this._streamTopic + "-" + this._streamPartitionId;
        this.segmentLogger = LoggerFactory.getLogger((String)(LLRealtimeSegmentDataManager.class.getName() + "_" + this._segmentNameStr));
        this._tableStreamName = this._tableNameWithType + "_" + this._streamTopic;
        this._memoryManager = LLRealtimeSegmentDataManager.getMemoryManager(realtimeTableDataManager.getConsumerDir(), this._segmentNameStr, indexLoadingConfig.isRealtimeOffHeapAllocation(), indexLoadingConfig.isDirectRealtimeOffHeapAllocation(), serverMetrics);
        List<String> sortedColumns = indexLoadingConfig.getSortedColumns();
        if (sortedColumns.isEmpty()) {
            this.segmentLogger.info("RealtimeDataResourceZKMetadata contains no information about sorted column for segment {}", (Object)this._llcSegmentName);
            this._sortedColumn = null;
        } else {
            String firstSortedColumn = sortedColumns.get(0);
            if (this._schema.hasColumn(firstSortedColumn)) {
                this.segmentLogger.info("Setting sorted column name: {} from RealtimeDataResourceZKMetadata for segment {}", (Object)firstSortedColumn, (Object)this._llcSegmentName);
                this._sortedColumn = firstSortedColumn;
            } else {
                this.segmentLogger.warn("Sorted column name: {} from RealtimeDataResourceZKMetadata is not existed in schema for segment {}.", (Object)firstSortedColumn, (Object)this._llcSegmentName);
                this._sortedColumn = null;
            }
        }
        Set<String> invertedIndexColumns = indexLoadingConfig.getInvertedIndexColumns();
        if (this._sortedColumn != null) {
            invertedIndexColumns.add(this._sortedColumn);
        }
        this._invertedIndexColumns = new ArrayList<String>(invertedIndexColumns);
        this._noDictionaryColumns = new ArrayList<String>(indexLoadingConfig.getNoDictionaryColumns());
        this._varLengthDictionaryColumns = new ArrayList<String>(indexLoadingConfig.getVarLengthDictionaryColumns());
        int segmentMaxRowCount = this._partitionLevelStreamConfig.getFlushThresholdRows();
        if (0 < segmentZKMetadata.getSizeThresholdToFlushSegment()) {
            segmentMaxRowCount = segmentZKMetadata.getSizeThresholdToFlushSegment();
        }
        this._segmentMaxRowCount = segmentMaxRowCount;
        this._isOffHeap = indexLoadingConfig.isRealtimeOffHeapAllocation();
        this._nullHandlingEnabled = indexingConfig.isNullHandlingEnabled();
        Set<String> textIndexColumns = indexLoadingConfig.getTextIndexColumns();
        this._textIndexColumns = new ArrayList<String>(textIndexColumns);
        String consumerDir = realtimeTableDataManager.getConsumerDir();
        RealtimeSegmentConfig.Builder realtimeSegmentConfigBuilder = new RealtimeSegmentConfig.Builder().setTableNameWithType(this._tableNameWithType).setSegmentName(this._segmentNameStr).setStreamName(this._streamTopic).setSchema(this._schema).setTimeColumnName(timeColumnName).setCapacity(this._segmentMaxRowCount).setAvgNumMultiValues(indexLoadingConfig.getRealtimeAvgMultiValueCount()).setNoDictionaryColumns(indexLoadingConfig.getNoDictionaryColumns()).setVarLengthDictionaryColumns(indexLoadingConfig.getVarLengthDictionaryColumns()).setInvertedIndexColumns(invertedIndexColumns).setTextIndexColumns(textIndexColumns).setRealtimeSegmentZKMetadata(segmentZKMetadata).setOffHeap(this._isOffHeap).setMemoryManager(this._memoryManager).setStatsHistory(realtimeTableDataManager.getStatsHistory()).setAggregateMetrics(indexingConfig.isAggregateMetrics()).setNullHandlingEnabled(this._nullHandlingEnabled).setConsumerDir(consumerDir).setUpsertMode(tableConfig.getUpsertMode()).setPartitionUpsertMetadataManager(partitionUpsertMetadataManager);
        Set<String> fieldsToRead = IngestionUtils.getFieldsForRecordExtractor(this._tableConfig.getIngestionConfig(), this._schema);
        this._messageDecoder = StreamDecoderProvider.create((StreamConfig)this._partitionLevelStreamConfig, fieldsToRead);
        this._clientId = this._streamTopic + "-" + this._streamPartitionId;
        this._recordTransformer = CompositeTransformer.getDefaultTransformer(tableConfig, schema);
        try {
            this._partitionConsumerSemaphore.acquire();
            this._acquiredConsumerSemaphore.set(true);
        }
        catch (InterruptedException e) {
            String errorMsg = "InterruptedException when acquiring the partitionConsumerSemaphore";
            this.segmentLogger.error(errorMsg);
            throw new RuntimeException(errorMsg + " for segment: " + this._segmentNameStr);
        }
        this.makeStreamConsumer("Starting");
        this.makeStreamMetadataProvider("Starting");
        SegmentPartitionConfig segmentPartitionConfig = indexingConfig.getSegmentPartitionConfig();
        if (segmentPartitionConfig != null) {
            Map columnPartitionMap = segmentPartitionConfig.getColumnPartitionMap();
            if (columnPartitionMap.size() == 1) {
                Map.Entry entry = columnPartitionMap.entrySet().iterator().next();
                String partitionColumn = (String)entry.getKey();
                ColumnPartitionConfig columnPartitionConfig = (ColumnPartitionConfig)entry.getValue();
                String partitionFunctionName = columnPartitionConfig.getFunctionName();
                int numPartitions = columnPartitionConfig.getNumPartitions();
                try {
                    int numStreamPartitions = this._streamMetadataProvider.fetchPartitionCount(5000L);
                    if (numStreamPartitions != numPartitions) {
                        this.segmentLogger.warn("Number of stream partitions: {} does not match number of partitions in the partition config: {}, using number of stream partitions", (Object)numStreamPartitions, (Object)numPartitions);
                        this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.REALTIME_PARTITION_MISMATCH, 1L);
                        numPartitions = numStreamPartitions;
                    }
                }
                catch (Exception e) {
                    this.segmentLogger.warn("Failed to get number of stream partitions in 5s, using number of partitions in the partition config: {}", (Object)numPartitions, (Object)e);
                    this.makeStreamMetadataProvider("Timeout getting number of stream partitions");
                }
                realtimeSegmentConfigBuilder.setPartitionColumn(partitionColumn);
                realtimeSegmentConfigBuilder.setPartitionFunction(PartitionFunctionFactory.getPartitionFunction(partitionFunctionName, numPartitions));
                realtimeSegmentConfigBuilder.setPartitionId(this._streamPartitionId);
            } else {
                this.segmentLogger.warn("Cannot partition on multiple columns: {}", columnPartitionMap.keySet());
            }
        }
        this._realtimeSegment = new MutableSegmentImpl(realtimeSegmentConfigBuilder.build(), serverMetrics);
        this._startOffset = this._streamPartitionMsgOffsetFactory.create(this._segmentZKMetadata.getStartOffset());
        this._currentOffset = this._streamPartitionMsgOffsetFactory.create(this._startOffset);
        this._resourceTmpDir = new File(resourceDataDir, "_tmp");
        if (!this._resourceTmpDir.exists()) {
            this._resourceTmpDir.mkdirs();
        }
        this._state = State.INITIAL_CONSUMING;
        this._consumeStartTime = now = this.now();
        long maxConsumeTimeMillis = this._partitionLevelStreamConfig.getFlushThresholdTimeMillis();
        this._consumeEndTime = segmentZKMetadata.getCreationTime() + maxConsumeTimeMillis;
        long minConsumeTimeMillis = Math.min(maxConsumeTimeMillis, TimeUnit.MILLISECONDS.convert(MINIMUM_CONSUME_TIME_MINUTES, TimeUnit.MINUTES));
        if (this._consumeEndTime - now < minConsumeTimeMillis) {
            this._consumeEndTime = now + minConsumeTimeMillis;
        }
        this._segmentCommitterFactory = new SegmentCommitterFactory(this.segmentLogger, this._protocolHandler, tableConfig, indexLoadingConfig, serverMetrics);
        this.segmentLogger.info("Starting consumption on realtime consuming segment {} maxRowCount {} maxEndTime {}", new Object[]{this._llcSegmentName, this._segmentMaxRowCount, new DateTime(this._consumeEndTime, DateTimeZone.UTC).toString()});
        this.start();
    }

    private void makeStreamConsumer(String reason) {
        if (this._partitionLevelConsumer != null) {
            this.closePartitionLevelConsumer();
        }
        this.segmentLogger.info("Creating new stream consumer, reason: {}", (Object)reason);
        this._partitionLevelConsumer = this._streamConsumerFactory.createPartitionLevelConsumer(this._clientId, this._streamPartitionId);
    }

    private void makeStreamMetadataProvider(String reason) {
        if (this._streamMetadataProvider != null) {
            this.closeStreamMetadataProvider();
        }
        this.segmentLogger.info("Creating new stream metadata provider, reason: {}", (Object)reason);
        this._streamMetadataProvider = this._streamConsumerFactory.createPartitionMetadataProvider(this._clientId, this._streamPartitionId);
    }

    private void updateCurrentDocumentCountMetrics() {
        long prevTime;
        long rowsIndexed = (long)this._numRowsIndexed - this._lastUpdatedRowsIndexed.get();
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.DOCUMENT_COUNT, rowsIndexed);
        this._lastUpdatedRowsIndexed.set(this._numRowsIndexed);
        long now = this.now();
        int rowsConsumed = this._numRowsConsumed - this._lastConsumedCount;
        long l = prevTime = this._lastConsumedCount == 0 ? this._consumeStartTime : this._lastLogTime;
        if (now - prevTime > TimeUnit.MINUTES.toMillis(1L) || rowsConsumed >= 100000) {
            this.segmentLogger.info("Consumed {} events from (rate:{}/s), currentOffset={}, numRowsConsumedSoFar={}, numRowsIndexedSoFar={}", new Object[]{rowsConsumed, Float.valueOf((float)rowsConsumed * 1000.0f / (float)(now - prevTime)), this._currentOffset, this._numRowsConsumed, this._numRowsIndexed});
            this._lastConsumedCount = this._numRowsConsumed;
            this._lastLogTime = now;
        }
    }

    @Override
    public MutableSegment getSegment() {
        return this._realtimeSegment;
    }

    @Override
    public String getSegmentName() {
        return this._segmentNameStr;
    }

    public class PartitionConsumer
    implements Runnable {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long initialConsumptionEnd = 0L;
            long lastCatchUpStart = 0L;
            long catchUpTimeMillis = 0L;
            LLRealtimeSegmentDataManager.this._startTimeMs = LLRealtimeSegmentDataManager.this.now();
            try {
                block14: while (!LLRealtimeSegmentDataManager.this._state.isFinal()) {
                    if (LLRealtimeSegmentDataManager.this._state.shouldConsume()) {
                        LLRealtimeSegmentDataManager.this.consumeLoop();
                    }
                    LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
                    if (!LLRealtimeSegmentDataManager.this._shouldStop) {
                        if (LLRealtimeSegmentDataManager.this._state == State.INITIAL_CONSUMING) {
                            initialConsumptionEnd = LLRealtimeSegmentDataManager.this.now();
                            LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_INITIAL_CONSUMPTION_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(initialConsumptionEnd - LLRealtimeSegmentDataManager.this._startTimeMs));
                        } else if (LLRealtimeSegmentDataManager.this._state == State.CATCHING_UP) {
                            LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_CATCHUP_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(catchUpTimeMillis += LLRealtimeSegmentDataManager.this.now() - lastCatchUpStart));
                        }
                        LLRealtimeSegmentDataManager.this._state = State.HOLDING;
                        SegmentCompletionProtocol.Response response = LLRealtimeSegmentDataManager.this.postSegmentConsumedMsg();
                        SegmentCompletionProtocol.ControllerResponseStatus status = response.getStatus();
                        StreamPartitionMsgOffset rspOffset = LLRealtimeSegmentDataManager.this.extractOffset(response);
                        switch (status) {
                            case NOT_LEADER: {
                                LLRealtimeSegmentDataManager.this.segmentLogger.warn("Got not leader response");
                                LLRealtimeSegmentDataManager.this.hold();
                                continue block14;
                            }
                            case CATCH_UP: {
                                if (rspOffset.compareTo((Object)LLRealtimeSegmentDataManager.this._currentOffset) <= 0) {
                                    LLRealtimeSegmentDataManager.this.segmentLogger.error("Invalid catchup offset {} in controller response, current offset {}", (Object)rspOffset, (Object)LLRealtimeSegmentDataManager.this._currentOffset);
                                    LLRealtimeSegmentDataManager.this.hold();
                                    continue block14;
                                }
                                LLRealtimeSegmentDataManager.this._state = State.CATCHING_UP;
                                LLRealtimeSegmentDataManager.this._finalOffset = rspOffset;
                                lastCatchUpStart = LLRealtimeSegmentDataManager.this.now();
                                continue block14;
                            }
                            case HOLD: {
                                LLRealtimeSegmentDataManager.this.hold();
                                continue block14;
                            }
                            case DISCARD: {
                                LLRealtimeSegmentDataManager.this._state = State.DISCARDED;
                                continue block14;
                            }
                            case KEEP: {
                                boolean success;
                                LLRealtimeSegmentDataManager.this._state = State.RETAINING;
                                CommonConstants.Segment.Realtime.CompletionMode segmentCompletionMode = LLRealtimeSegmentDataManager.this.getSegmentCompletionMode();
                                switch (segmentCompletionMode) {
                                    case DOWNLOAD: {
                                        LLRealtimeSegmentDataManager.this._state = State.DISCARDED;
                                        break;
                                    }
                                    case DEFAULT: {
                                        success = LLRealtimeSegmentDataManager.this.buildSegmentAndReplace();
                                        if (success) {
                                            LLRealtimeSegmentDataManager.this._state = State.RETAINED;
                                            break;
                                        }
                                        LLRealtimeSegmentDataManager.this._state = State.ERROR;
                                        continue block14;
                                    }
                                }
                                continue block14;
                            }
                            case COMMIT: {
                                LLRealtimeSegmentDataManager.this._state = State.COMMITTING;
                                long buildTimeSeconds = response.getBuildTimeSeconds();
                                LLRealtimeSegmentDataManager.this.buildSegmentForCommit(buildTimeSeconds * 1000L);
                                if (LLRealtimeSegmentDataManager.this._segmentBuildDescriptor == null) {
                                    LLRealtimeSegmentDataManager.this._state = State.ERROR;
                                    continue block14;
                                }
                                boolean success = LLRealtimeSegmentDataManager.this.commitSegment(response.getControllerVipUrl(), response.isSplitCommit() && LLRealtimeSegmentDataManager.this._indexLoadingConfig.isEnableSplitCommit());
                                if (success) {
                                    LLRealtimeSegmentDataManager.this._state = State.COMMITTED;
                                    continue block14;
                                }
                                LLRealtimeSegmentDataManager.this._state = State.HOLDING;
                                LLRealtimeSegmentDataManager.this.segmentLogger.info("Could not commit segment. Retrying after hold");
                                LLRealtimeSegmentDataManager.this.hold();
                                continue block14;
                            }
                        }
                        LLRealtimeSegmentDataManager.this.segmentLogger.error("Holding after response from Controller: {}", (Object)response.toJsonString());
                        LLRealtimeSegmentDataManager.this.hold();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LLRealtimeSegmentDataManager.this.segmentLogger.error("Exception while in work", (Throwable)e);
                LLRealtimeSegmentDataManager.this.postStopConsumedMsg(e.getClass().getName());
                LLRealtimeSegmentDataManager.this._state = State.ERROR;
                LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
                return;
            }
            LLRealtimeSegmentDataManager.this.removeSegmentFile();
            if (initialConsumptionEnd != 0L) {
                LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LAST_REALTIME_SEGMENT_COMPLETION_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(LLRealtimeSegmentDataManager.this.now() - initialConsumptionEnd));
            }
            LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, (AbstractMetrics.Gauge)ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        }
    }

    @VisibleForTesting
    public class SegmentBuildDescriptor {
        final File _segmentTarFile;
        final Map<String, File> _metadataFileMap;
        final StreamPartitionMsgOffset _offset;
        final long _waitTimeMillis;
        final long _buildTimeMillis;
        final long _segmentSizeBytes;

        public SegmentBuildDescriptor(@Nullable File segmentTarFile, Map<String, File> metadataFileMap, StreamPartitionMsgOffset offset, long buildTimeMillis, long waitTimeMillis, long segmentSizeBytes) {
            this._segmentTarFile = segmentTarFile;
            this._metadataFileMap = metadataFileMap;
            this._offset = LLRealtimeSegmentDataManager.this._streamPartitionMsgOffsetFactory.create(offset);
            this._buildTimeMillis = buildTimeMillis;
            this._waitTimeMillis = waitTimeMillis;
            this._segmentSizeBytes = segmentSizeBytes;
        }

        public StreamPartitionMsgOffset getOffset() {
            return this._offset;
        }

        public long getBuildTimeMillis() {
            return this._buildTimeMillis;
        }

        public long getWaitTimeMillis() {
            return this._waitTimeMillis;
        }

        @Nullable
        public File getSegmentTarFile() {
            return this._segmentTarFile;
        }

        @Nullable
        public Map<String, File> getMetadataFiles() {
            return this._metadataFileMap;
        }

        public long getSegmentSizeBytes() {
            return this._segmentSizeBytes;
        }

        public void deleteSegmentFile() {
            if (this._segmentTarFile != null) {
                FileUtils.deleteQuietly((File)this._segmentTarFile);
            }
        }
    }

    protected static enum State {
        INITIAL_CONSUMING,
        CATCHING_UP,
        HOLDING,
        CONSUMING_TO_ONLINE,
        RETAINING,
        COMMITTING,
        DISCARDED,
        RETAINED,
        COMMITTED,
        ERROR;


        public boolean shouldConsume() {
            return this.equals((Object)INITIAL_CONSUMING) || this.equals((Object)CATCHING_UP) || this.equals((Object)CONSUMING_TO_ONLINE);
        }

        public boolean isFinal() {
            return this.equals((Object)ERROR) || this.equals((Object)COMMITTED) || this.equals((Object)RETAINED) || this.equals((Object)DISCARDED);
        }
    }
}

