/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.helix.HelixManager;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.data.manager.SegmentDataManager;
import org.apache.pinot.core.data.manager.TableDataManager;
import org.apache.pinot.core.data.manager.config.TableDataManagerConfig;
import org.apache.pinot.core.data.manager.offline.ImmutableSegmentDataManager;
import org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseTableDataManager
implements TableDataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTableDataManager.class);
    protected final ConcurrentHashMap<String, SegmentDataManager> _segmentDataManagerMap = new ConcurrentHashMap();
    protected TableDataManagerConfig _tableDataManagerConfig;
    protected String _instanceId;
    protected ZkHelixPropertyStore<ZNRecord> _propertyStore;
    protected ServerMetrics _serverMetrics;
    protected String _tableNameWithType;
    protected String _tableDataDir;
    protected File _indexDir;
    protected Logger _logger;
    protected HelixManager _helixManager;

    @Override
    public void init(TableDataManagerConfig tableDataManagerConfig, String instanceId, ZkHelixPropertyStore<ZNRecord> propertyStore, ServerMetrics serverMetrics, HelixManager helixManager) {
        LOGGER.info("Initializing table data manager for table: {}", (Object)tableDataManagerConfig.getTableName());
        this._tableDataManagerConfig = tableDataManagerConfig;
        this._instanceId = instanceId;
        this._propertyStore = propertyStore;
        this._serverMetrics = serverMetrics;
        this._helixManager = helixManager;
        this._tableNameWithType = tableDataManagerConfig.getTableName();
        this._tableDataDir = tableDataManagerConfig.getDataDir();
        this._indexDir = new File(this._tableDataDir);
        if (!this._indexDir.exists()) {
            Preconditions.checkState((boolean)this._indexDir.mkdirs());
        }
        this._logger = LoggerFactory.getLogger((String)(this._tableNameWithType + "-" + this.getClass().getSimpleName()));
        this.doInit();
        this._logger.info("Initialized table data manager for table: {} with data directory: {}", (Object)this._tableNameWithType, (Object)this._tableDataDir);
    }

    protected abstract void doInit();

    @Override
    public void start() {
        this._logger.info("Starting table data manager for table: {}", (Object)this._tableNameWithType);
        this.doStart();
        this._logger.info("Started table data manager for table: {}", (Object)this._tableNameWithType);
    }

    protected abstract void doStart();

    @Override
    public void shutDown() {
        this._logger.info("Shutting down table data manager for table: {}", (Object)this._tableNameWithType);
        this.doShutdown();
        this._logger.info("Shut down table data manager for table: {}", (Object)this._tableNameWithType);
    }

    protected abstract void doShutdown();

    @Override
    public void addSegment(ImmutableSegment immutableSegment) {
        String segmentName = immutableSegment.getSegmentName();
        this._logger.info("Adding immutable segment: {} to table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.DOCUMENT_COUNT, (long)immutableSegment.getSegmentMetadata().getTotalDocs());
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.SEGMENT_COUNT, 1L);
        ImmutableSegmentDataManager newSegmentManager = new ImmutableSegmentDataManager(immutableSegment);
        SegmentDataManager oldSegmentManager = this._segmentDataManagerMap.put(segmentName, newSegmentManager);
        if (oldSegmentManager == null) {
            this._logger.info("Added new immutable segment: {} to table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        } else {
            this._logger.info("Replaced immutable segment: {} of table: {}", (Object)segmentName, (Object)this._tableNameWithType);
            this.releaseSegment(oldSegmentManager);
        }
    }

    @Override
    public void addSegment(File indexDir, IndexLoadingConfig indexLoadingConfig) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSegment(String segmentName, TableConfig tableConfig, IndexLoadingConfig indexLoadingConfig) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSegment(String segmentName) {
        this._logger.info("Removing segment: {} from table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        SegmentDataManager segmentDataManager = this._segmentDataManagerMap.remove(segmentName);
        if (segmentDataManager != null) {
            this.releaseSegment(segmentDataManager);
            this._logger.info("Removed segment: {} from table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        } else {
            this._logger.info("Failed to find segment: {} in table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        }
    }

    @Override
    public List<SegmentDataManager> acquireAllSegments() {
        ArrayList<SegmentDataManager> segmentDataManagers = new ArrayList<SegmentDataManager>();
        for (SegmentDataManager segmentDataManager : this._segmentDataManagerMap.values()) {
            if (!segmentDataManager.increaseReferenceCount()) continue;
            segmentDataManagers.add(segmentDataManager);
        }
        return segmentDataManagers;
    }

    @Override
    public List<SegmentDataManager> acquireSegments(List<String> segmentNames) {
        ArrayList<SegmentDataManager> segmentDataManagers = new ArrayList<SegmentDataManager>();
        for (String segmentName : segmentNames) {
            SegmentDataManager segmentDataManager = this._segmentDataManagerMap.get(segmentName);
            if (segmentDataManager == null || !segmentDataManager.increaseReferenceCount()) continue;
            segmentDataManagers.add(segmentDataManager);
        }
        return segmentDataManagers;
    }

    @Override
    @Nullable
    public SegmentDataManager acquireSegment(String segmentName) {
        SegmentDataManager segmentDataManager = this._segmentDataManagerMap.get(segmentName);
        if (segmentDataManager != null && segmentDataManager.increaseReferenceCount()) {
            return segmentDataManager;
        }
        return null;
    }

    @Override
    public void releaseSegment(SegmentDataManager segmentDataManager) {
        if (segmentDataManager.decreaseReferenceCount()) {
            this.closeSegment(segmentDataManager);
        }
    }

    private void closeSegment(SegmentDataManager segmentDataManager) {
        String segmentName = segmentDataManager.getSegmentName();
        this._logger.info("Closing segment: {} of table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.SEGMENT_COUNT, -1L);
        this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.DELETED_SEGMENT_COUNT, 1L);
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.DOCUMENT_COUNT, (long)(-segmentDataManager.getSegment().getSegmentMetadata().getTotalDocs()));
        segmentDataManager.destroy();
        this._logger.info("Closed segment: {} of table: {}", (Object)segmentName, (Object)this._tableNameWithType);
    }

    @Override
    public String getTableName() {
        return this._tableNameWithType;
    }

    @Override
    public File getTableDataDir() {
        return this._indexDir;
    }
}

