/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.function;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.data.function.FunctionEvaluator;
import org.apache.pinot.spi.data.TimeGranularitySpec;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.utils.TimeConverter;
import org.apache.pinot.spi.utils.TimeUtils;

public class TimeSpecFunctionEvaluator
implements FunctionEvaluator {
    private final String _incomingTimeColumn;
    private final String _outgoingTimeColumn;
    private final TimeConverter _incomingTimeConverter;
    private final TimeConverter _outgoingTimeConverter;
    private boolean _isValidated = false;

    public TimeSpecFunctionEvaluator(TimeGranularitySpec incomingGranularitySpec, TimeGranularitySpec outgoingGranularitySpec) {
        Preconditions.checkState((!incomingGranularitySpec.equals((Object)outgoingGranularitySpec) ? 1 : 0) != 0);
        this._incomingTimeColumn = incomingGranularitySpec.getName();
        this._outgoingTimeColumn = outgoingGranularitySpec.getName();
        Preconditions.checkState((!this._incomingTimeColumn.equals(this._outgoingTimeColumn) ? 1 : 0) != 0);
        this._incomingTimeConverter = new TimeConverter(incomingGranularitySpec);
        this._outgoingTimeConverter = new TimeConverter(outgoingGranularitySpec);
    }

    @Override
    public List<String> getArguments() {
        return Collections.singletonList(this._incomingTimeColumn);
    }

    @Override
    public Object evaluate(GenericRow genericRow) {
        Object incomingTimeValue = genericRow.getValue(this._incomingTimeColumn);
        if (!this._isValidated) {
            if (this._incomingTimeColumn == null || !TimeUtils.timeValueInValidRange((long)this._incomingTimeConverter.toMillisSinceEpoch(incomingTimeValue))) {
                throw new IllegalStateException("No valid time value found in incoming time column: " + this._incomingTimeColumn);
            }
            this._isValidated = true;
        }
        return this._outgoingTimeConverter.fromMillisSinceEpoch(this._incomingTimeConverter.toMillisSinceEpoch(incomingTimeValue));
    }
}

