/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.function;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionInvoker;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.core.data.function.FunctionEvaluator;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.FunctionContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextConverterUtils;
import org.apache.pinot.spi.data.readers.GenericRow;

public class InbuiltFunctionEvaluator
implements FunctionEvaluator {
    private final ExecutableNode _rootNode;
    private final List<String> _arguments = new ArrayList<String>();

    public InbuiltFunctionEvaluator(String functionExpression) {
        ExpressionContext expression = QueryContextConverterUtils.getExpression(functionExpression);
        Preconditions.checkArgument((expression.getType() == ExpressionContext.Type.FUNCTION ? 1 : 0) != 0, (String)"Invalid function expression: %s", (Object)functionExpression);
        this._rootNode = this.planExecution(expression.getFunction());
    }

    private FunctionExecutionNode planExecution(FunctionContext function) {
        List<ExpressionContext> arguments = function.getArguments();
        int numArguments = arguments.size();
        ExecutableNode[] childNodes = new ExecutableNode[numArguments];
        for (int i = 0; i < numArguments; ++i) {
            ExecutableNode childNode;
            ExpressionContext argument = arguments.get(i);
            switch (argument.getType()) {
                case FUNCTION: {
                    childNode = this.planExecution(argument.getFunction());
                    break;
                }
                case IDENTIFIER: {
                    String columnName = argument.getIdentifier();
                    childNode = new ColumnExecutionNode(columnName);
                    this._arguments.add(columnName);
                    break;
                }
                case LITERAL: {
                    childNode = new ConstantExecutionNode(argument.getLiteral());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            childNodes[i] = childNode;
        }
        FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo((String)function.getFunctionName(), (int)numArguments);
        Preconditions.checkState((functionInfo != null ? 1 : 0) != 0, (String)"Unsupported function: %s with %s parameters", (Object)function.getFunctionName(), (int)numArguments);
        return new FunctionExecutionNode(functionInfo, childNodes);
    }

    @Override
    public List<String> getArguments() {
        return this._arguments;
    }

    @Override
    public Object evaluate(GenericRow row) {
        return this._rootNode.execute(row);
    }

    private static class ColumnExecutionNode
    implements ExecutableNode {
        final String _column;

        ColumnExecutionNode(String column) {
            this._column = column;
        }

        @Override
        public Object execute(GenericRow row) {
            return row.getValue(this._column);
        }
    }

    private static class ConstantExecutionNode
    implements ExecutableNode {
        final String _value;

        ConstantExecutionNode(String value) {
            this._value = value;
        }

        @Override
        public String execute(GenericRow row) {
            return this._value;
        }
    }

    private static class FunctionExecutionNode
    implements ExecutableNode {
        final FunctionInvoker _functionInvoker;
        final ExecutableNode[] _argumentNodes;
        final Object[] _arguments;

        FunctionExecutionNode(FunctionInfo functionInfo, ExecutableNode[] argumentNodes) {
            this._functionInvoker = new FunctionInvoker(functionInfo);
            this._argumentNodes = argumentNodes;
            this._arguments = new Object[this._argumentNodes.length];
        }

        @Override
        public Object execute(GenericRow row) {
            int numArguments = this._argumentNodes.length;
            for (int i = 0; i < numArguments; ++i) {
                this._arguments[i] = this._argumentNodes[i].execute(row);
            }
            this._functionInvoker.convertTypes(this._arguments);
            return this._functionInvoker.invoke(this._arguments);
        }
    }

    private static interface ExecutableNode {
        public Object execute(GenericRow var1);
    }
}

