/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.aggregator;

import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.core.data.aggregator.AvgValueAggregator;
import org.apache.pinot.core.data.aggregator.CountValueAggregator;
import org.apache.pinot.core.data.aggregator.DistinctCountBitmapValueAggregator;
import org.apache.pinot.core.data.aggregator.DistinctCountHLLValueAggregator;
import org.apache.pinot.core.data.aggregator.MaxValueAggregator;
import org.apache.pinot.core.data.aggregator.MinMaxRangeValueAggregator;
import org.apache.pinot.core.data.aggregator.MinValueAggregator;
import org.apache.pinot.core.data.aggregator.PercentileEstValueAggregator;
import org.apache.pinot.core.data.aggregator.PercentileTDigestValueAggregator;
import org.apache.pinot.core.data.aggregator.SumValueAggregator;
import org.apache.pinot.core.data.aggregator.ValueAggregator;
import org.apache.pinot.spi.data.FieldSpec;

public class ValueAggregatorFactory {
    private ValueAggregatorFactory() {
    }

    public static ValueAggregator getValueAggregator(AggregationFunctionType aggregationType) {
        switch (aggregationType) {
            case COUNT: {
                return new CountValueAggregator();
            }
            case MIN: {
                return new MinValueAggregator();
            }
            case MAX: {
                return new MaxValueAggregator();
            }
            case SUM: {
                return new SumValueAggregator();
            }
            case AVG: {
                return new AvgValueAggregator();
            }
            case MINMAXRANGE: {
                return new MinMaxRangeValueAggregator();
            }
            case DISTINCTCOUNTBITMAP: {
                return new DistinctCountBitmapValueAggregator();
            }
            case DISTINCTCOUNTHLL: 
            case DISTINCTCOUNTRAWHLL: {
                return new DistinctCountHLLValueAggregator();
            }
            case PERCENTILEEST: {
                return new PercentileEstValueAggregator();
            }
            case PERCENTILETDIGEST: {
                return new PercentileTDigestValueAggregator();
            }
        }
        throw new IllegalStateException("Unsupported aggregation type: " + aggregationType);
    }

    public static FieldSpec.DataType getAggregatedValueType(AggregationFunctionType aggregationType) {
        switch (aggregationType) {
            case COUNT: {
                return CountValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case MIN: {
                return MinValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case MAX: {
                return MaxValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case SUM: {
                return SumValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case AVG: {
                return AvgValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case MINMAXRANGE: {
                return MinMaxRangeValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case DISTINCTCOUNTBITMAP: {
                return DistinctCountBitmapValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case DISTINCTCOUNTHLL: 
            case DISTINCTCOUNTRAWHLL: {
                return DistinctCountHLLValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case PERCENTILEEST: {
                return PercentileEstValueAggregator.AGGREGATED_VALUE_TYPE;
            }
            case PERCENTILETDIGEST: {
                return PercentileTDigestValueAggregator.AGGREGATED_VALUE_TYPE;
            }
        }
        throw new IllegalStateException("Unsupported aggregation type: " + aggregationType);
    }
}

