/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.aggregator;

import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.data.aggregator.ValueAggregator;
import org.apache.pinot.core.query.aggregation.function.customobject.QuantileDigest;
import org.apache.pinot.spi.data.FieldSpec;

public class PercentileEstValueAggregator
implements ValueAggregator<Object, QuantileDigest> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private int _maxByteSize;

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.PERCENTILEEST;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public QuantileDigest getInitialAggregatedValue(Object rawValue) {
        QuantileDigest initialValue;
        if (rawValue instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            initialValue = this.deserializeAggregatedValue(bytes);
            this._maxByteSize = Math.max(this._maxByteSize, bytes.length);
        } else {
            initialValue = new QuantileDigest(0.05);
            initialValue.add(((Number)rawValue).longValue());
            this._maxByteSize = Math.max(this._maxByteSize, initialValue.getByteSize());
        }
        return initialValue;
    }

    @Override
    public QuantileDigest applyRawValue(QuantileDigest value, Object rawValue) {
        if (rawValue instanceof byte[]) {
            value.merge(this.deserializeAggregatedValue((byte[])rawValue));
        } else {
            value.add(((Number)rawValue).longValue());
        }
        this._maxByteSize = Math.max(this._maxByteSize, value.getByteSize());
        return value;
    }

    @Override
    public QuantileDigest applyAggregatedValue(QuantileDigest value, QuantileDigest aggregatedValue) {
        value.merge(aggregatedValue);
        this._maxByteSize = Math.max(this._maxByteSize, value.getByteSize());
        return value;
    }

    @Override
    public QuantileDigest cloneAggregatedValue(QuantileDigest value) {
        return this.deserializeAggregatedValue(this.serializeAggregatedValue(value));
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return this._maxByteSize;
    }

    @Override
    public byte[] serializeAggregatedValue(QuantileDigest value) {
        return ObjectSerDeUtils.QUANTILE_DIGEST_SER_DE.serialize(value);
    }

    @Override
    public QuantileDigest deserializeAggregatedValue(byte[] bytes) {
        return ObjectSerDeUtils.QUANTILE_DIGEST_SER_DE.deserialize(bytes);
    }
}

