/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.aggregator;

import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.data.aggregator.ValueAggregator;
import org.apache.pinot.core.query.aggregation.function.customobject.MinMaxRangePair;
import org.apache.pinot.spi.data.FieldSpec;

public class MinMaxRangeValueAggregator
implements ValueAggregator<Object, MinMaxRangePair> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.MINMAXRANGE;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public MinMaxRangePair getInitialAggregatedValue(Object rawValue) {
        if (rawValue instanceof byte[]) {
            return this.deserializeAggregatedValue((byte[])rawValue);
        }
        double doubleValue = ((Number)rawValue).doubleValue();
        return new MinMaxRangePair(doubleValue, doubleValue);
    }

    @Override
    public MinMaxRangePair applyRawValue(MinMaxRangePair value, Object rawValue) {
        if (rawValue instanceof byte[]) {
            value.apply(this.deserializeAggregatedValue((byte[])rawValue));
        } else {
            double doubleValue = ((Number)rawValue).doubleValue();
            value.apply(doubleValue, doubleValue);
        }
        return value;
    }

    @Override
    public MinMaxRangePair applyAggregatedValue(MinMaxRangePair value, MinMaxRangePair aggregatedValue) {
        value.apply(aggregatedValue);
        return value;
    }

    @Override
    public MinMaxRangePair cloneAggregatedValue(MinMaxRangePair value) {
        return new MinMaxRangePair(value.getMin(), value.getMax());
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return 16;
    }

    @Override
    public byte[] serializeAggregatedValue(MinMaxRangePair value) {
        return ObjectSerDeUtils.MIN_MAX_RANGE_PAIR_SER_DE.serialize(value);
    }

    @Override
    public MinMaxRangePair deserializeAggregatedValue(byte[] bytes) {
        return ObjectSerDeUtils.MIN_MAX_RANGE_PAIR_SER_DE.deserialize(bytes);
    }
}

