/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.aggregator;

import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.core.data.aggregator.ValueAggregator;
import org.apache.pinot.spi.data.FieldSpec;

public class CountValueAggregator
implements ValueAggregator<Void, Long> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.LONG;

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.COUNT;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public Long getInitialAggregatedValue(Void rawValue) {
        return 1L;
    }

    @Override
    public Long applyRawValue(Long value, Void rawValue) {
        return value + 1L;
    }

    @Override
    public Long applyAggregatedValue(Long value, Long aggregatedValue) {
        return value + aggregatedValue;
    }

    @Override
    public Long cloneAggregatedValue(Long value) {
        return value;
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return 8;
    }

    @Override
    public byte[] serializeAggregatedValue(Long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long deserializeAggregatedValue(byte[] bytes) {
        throw new UnsupportedOperationException();
    }
}

