/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.aggregator;

import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.data.aggregator.ValueAggregator;
import org.apache.pinot.core.query.aggregation.function.customobject.AvgPair;
import org.apache.pinot.spi.data.FieldSpec;

public class AvgValueAggregator
implements ValueAggregator<Object, AvgPair> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.AVG;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public AvgPair getInitialAggregatedValue(Object rawValue) {
        if (rawValue instanceof byte[]) {
            return this.deserializeAggregatedValue((byte[])rawValue);
        }
        return new AvgPair(((Number)rawValue).doubleValue(), 1L);
    }

    @Override
    public AvgPair applyRawValue(AvgPair value, Object rawValue) {
        if (rawValue instanceof byte[]) {
            value.apply(this.deserializeAggregatedValue((byte[])rawValue));
        } else {
            value.apply(((Number)rawValue).doubleValue(), 1L);
        }
        return value;
    }

    @Override
    public AvgPair applyAggregatedValue(AvgPair value, AvgPair aggregatedValue) {
        value.apply(aggregatedValue);
        return value;
    }

    @Override
    public AvgPair cloneAggregatedValue(AvgPair value) {
        return new AvgPair(value.getSum(), value.getCount());
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return 16;
    }

    @Override
    public byte[] serializeAggregatedValue(AvgPair value) {
        return ObjectSerDeUtils.AVG_PAIR_SER_DE.serialize(value);
    }

    @Override
    public AvgPair deserializeAggregatedValue(byte[] bytes) {
        return ObjectSerDeUtils.AVG_PAIR_SER_DE.deserialize(bytes);
    }
}

