/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.QueryOptions;

public class DataTableUtils {
    private DataTableUtils() {
    }

    public static int computeColumnOffsets(DataSchema dataSchema, int[] columnOffsets) {
        int numColumns = columnOffsets.length;
        assert (numColumns == dataSchema.size());
        int rowSizeInBytes = 0;
        block7: for (int i = 0; i < numColumns; ++i) {
            columnOffsets[i] = rowSizeInBytes;
            switch (dataSchema.getColumnDataType(i)) {
                case INT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case LONG: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case FLOAT: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case DOUBLE: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case STRING: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                default: {
                    rowSizeInBytes += 8;
                }
            }
        }
        return rowSizeInBytes;
    }

    public static DataTable buildEmptyDataTable(QueryContext queryContext) throws IOException {
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        if (aggregationFunctions == null) {
            List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
            int numSelectExpressions = selectExpressions.size();
            String[] columnNames = new String[numSelectExpressions];
            for (int i = 0; i < numSelectExpressions; ++i) {
                columnNames[i] = selectExpressions.get(i).toString();
            }
            Object[] columnDataTypes = new DataSchema.ColumnDataType[numSelectExpressions];
            Arrays.fill(columnDataTypes, DataSchema.ColumnDataType.STRING);
            DataSchema dataSchema = new DataSchema(columnNames, (DataSchema.ColumnDataType[])columnDataTypes);
            return new DataTableBuilder(dataSchema).build();
        }
        int numAggregations = aggregationFunctions.length;
        List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
        if (groupByExpressions != null) {
            if (new QueryOptions(queryContext.getQueryOptions()).isGroupByModeSQL()) {
                int numColumns = groupByExpressions.size() + numAggregations;
                String[] columnNames = new String[numColumns];
                DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
                int index = 0;
                for (ExpressionContext groupByExpression : groupByExpressions) {
                    columnNames[index] = groupByExpression.toString();
                    columnDataTypes[index] = DataSchema.ColumnDataType.STRING;
                    ++index;
                }
                for (AggregationFunction aggregationFunction : aggregationFunctions) {
                    columnNames[index] = aggregationFunction.getResultColumnName();
                    columnDataTypes[index] = aggregationFunction.getIntermediateResultColumnType();
                    ++index;
                }
                return new DataTableBuilder(new DataSchema(columnNames, columnDataTypes)).build();
            }
            String[] columnNames = new String[]{"functionName", "GroupByResultMap"};
            DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.STRING, DataSchema.ColumnDataType.OBJECT};
            DataTableBuilder dataTableBuilder = new DataTableBuilder(new DataSchema(columnNames, columnDataTypes));
            for (AggregationFunction aggregationFunction : aggregationFunctions) {
                dataTableBuilder.startRow();
                dataTableBuilder.setColumn(0, aggregationFunction.getColumnName());
                dataTableBuilder.setColumn(1, Collections.emptyMap());
                dataTableBuilder.finishRow();
            }
            return dataTableBuilder.build();
        }
        String[] aggregationColumnNames = new String[numAggregations];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numAggregations];
        Object[] aggregationResults = new Object[numAggregations];
        for (int i = 0; i < numAggregations; ++i) {
            AggregationFunction aggregationFunction = aggregationFunctions[i];
            aggregationColumnNames[i] = aggregationFunction.getColumnName();
            columnDataTypes[i] = aggregationFunction.getIntermediateResultColumnType();
            aggregationResults[i] = aggregationFunction.extractAggregationResult(aggregationFunction.createAggregationResultHolder());
        }
        DataTableBuilder dataTableBuilder = new DataTableBuilder(new DataSchema(aggregationColumnNames, columnDataTypes));
        dataTableBuilder.startRow();
        block10: for (int i = 0; i < numAggregations; ++i) {
            switch (columnDataTypes[i]) {
                case LONG: {
                    dataTableBuilder.setColumn(i, ((Number)aggregationResults[i]).longValue());
                    continue block10;
                }
                case DOUBLE: {
                    dataTableBuilder.setColumn(i, (Double)aggregationResults[i]);
                    continue block10;
                }
                case OBJECT: {
                    dataTableBuilder.setColumn(i, aggregationResults[i]);
                    continue block10;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported aggregation column data type: " + columnDataTypes[i] + " for column: " + aggregationColumnNames[i]);
                }
            }
        }
        dataTableBuilder.finishRow();
        return dataTableBuilder.build();
    }
}

