/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.pinot.core.common.DataFetcher;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.EqualityUtils;

public class DataBlockCache {
    private final DataFetcher _dataFetcher;
    private final Set<String> _columnDictIdLoaded = new HashSet<String>();
    private final Set<ColumnTypePair> _columnValueLoaded = new HashSet<ColumnTypePair>();
    private final Set<String> _columnNumValuesLoaded = new HashSet<String>();
    private final Map<String, Object> _dictIdsMap = new HashMap<String, Object>();
    private final Map<ColumnTypePair, Object> _valuesMap = new HashMap<ColumnTypePair, Object>();
    private final Map<String, int[]> _numValuesMap = new HashMap<String, int[]>();
    private int[] _docIds;
    private int _length;

    public DataBlockCache(DataFetcher dataFetcher) {
        this._dataFetcher = dataFetcher;
    }

    public void initNewBlock(int[] docIds, int length) {
        this._docIds = docIds;
        this._length = length;
        this._columnDictIdLoaded.clear();
        this._columnValueLoaded.clear();
        this._columnNumValuesLoaded.clear();
    }

    public int getNumDocs() {
        return this._length;
    }

    public int[] getDictIdsForSVColumn(String column) {
        int[] dictIds = (int[])this._dictIdsMap.get(column);
        if (this._columnDictIdLoaded.add(column)) {
            if (dictIds == null) {
                dictIds = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
                this._dictIdsMap.put(column, dictIds);
            }
            this._dataFetcher.fetchDictIds(column, this._docIds, this._length, dictIds);
        }
        return dictIds;
    }

    public int[] getIntValuesForSVColumn(String column) {
        ColumnTypePair key = new ColumnTypePair(column, FieldSpec.DataType.INT);
        int[] intValues = (int[])this._valuesMap.get(key);
        if (this._columnValueLoaded.add(key)) {
            if (intValues == null) {
                intValues = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
                this._valuesMap.put(key, intValues);
            }
            this._dataFetcher.fetchIntValues(column, this._docIds, this._length, intValues);
        }
        return intValues;
    }

    public long[] getLongValuesForSVColumn(String column) {
        ColumnTypePair key = new ColumnTypePair(column, FieldSpec.DataType.LONG);
        long[] longValues = (long[])this._valuesMap.get(key);
        if (this._columnValueLoaded.add(key)) {
            if (longValues == null) {
                longValues = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL];
                this._valuesMap.put(key, longValues);
            }
            this._dataFetcher.fetchLongValues(column, this._docIds, this._length, longValues);
        }
        return longValues;
    }

    public float[] getFloatValuesForSVColumn(String column) {
        ColumnTypePair key = new ColumnTypePair(column, FieldSpec.DataType.FLOAT);
        float[] floatValues = (float[])this._valuesMap.get(key);
        if (this._columnValueLoaded.add(key)) {
            if (floatValues == null) {
                floatValues = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL];
                this._valuesMap.put(key, floatValues);
            }
            this._dataFetcher.fetchFloatValues(column, this._docIds, this._length, floatValues);
        }
        return floatValues;
    }

    public double[] getDoubleValuesForSVColumn(String column) {
        ColumnTypePair key = new ColumnTypePair(column, FieldSpec.DataType.DOUBLE);
        double[] doubleValues = (double[])this._valuesMap.get(key);
        if (this._columnValueLoaded.add(key)) {
            if (doubleValues == null) {
                doubleValues = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
                this._valuesMap.put(key, doubleValues);
            }
            this._dataFetcher.fetchDoubleValues(column, this._docIds, this._length, doubleValues);
        }
        return doubleValues;
    }

    public String[] getStringValuesForSVColumn(String column) {
        ColumnTypePair key = new ColumnTypePair(column, FieldSpec.DataType.STRING);
        String[] stringValues = (String[])this._valuesMap.get(key);
        if (this._columnValueLoaded.add(key)) {
            if (stringValues == null) {
                stringValues = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL];
                this._valuesMap.put(key, stringValues);
            }
            this._dataFetcher.fetchStringValues(column, this._docIds, this._length, stringValues);
        }
        return stringValues;
    }

    public byte[][] getBytesValuesForSVColumn(String column) {
        ColumnTypePair key = new ColumnTypePair(column, FieldSpec.DataType.BYTES);
        Object bytesValues = (byte[][])this._valuesMap.get(key);
        if (this._columnValueLoaded.add(key)) {
            if (bytesValues == null) {
                bytesValues = new byte[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
                this._valuesMap.put(key, bytesValues);
            }
            this._dataFetcher.fetchBytesValues(column, this._docIds, this._length, (byte[][])bytesValues);
        }
        return bytesValues;
    }

    public int[][] getDictIdsForMVColumn(String column) {
        Object dictIds = (int[][])this._dictIdsMap.get(column);
        if (this._columnDictIdLoaded.add(column)) {
            if (dictIds == null) {
                dictIds = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
                this._dictIdsMap.put(column, dictIds);
            }
            this._dataFetcher.fetchDictIds(column, this._docIds, this._length, (int[][])dictIds);
        }
        return dictIds;
    }

    public int[][] getIntValuesForMVColumn(String column) {
        ColumnTypePair key = new ColumnTypePair(column, FieldSpec.DataType.INT);
        Object intValues = (int[][])this._valuesMap.get(key);
        if (this._columnValueLoaded.add(key)) {
            if (intValues == null) {
                intValues = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
                this._valuesMap.put(key, intValues);
            }
            this._dataFetcher.fetchIntValues(column, this._docIds, this._length, (int[][])intValues);
        }
        return intValues;
    }

    public long[][] getLongValuesForMVColumn(String column) {
        ColumnTypePair key = new ColumnTypePair(column, FieldSpec.DataType.LONG);
        Object longValues = (long[][])this._valuesMap.get(key);
        if (this._columnValueLoaded.add(key)) {
            if (longValues == null) {
                longValues = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
                this._valuesMap.put(key, longValues);
            }
            this._dataFetcher.fetchLongValues(column, this._docIds, this._length, (long[][])longValues);
        }
        return longValues;
    }

    public float[][] getFloatValuesForMVColumn(String column) {
        ColumnTypePair key = new ColumnTypePair(column, FieldSpec.DataType.FLOAT);
        Object floatValues = (float[][])this._valuesMap.get(key);
        if (this._columnValueLoaded.add(key)) {
            if (floatValues == null) {
                floatValues = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
                this._valuesMap.put(key, floatValues);
            }
            this._dataFetcher.fetchFloatValues(column, this._docIds, this._length, (float[][])floatValues);
        }
        return floatValues;
    }

    public double[][] getDoubleValuesForMVColumn(String column) {
        ColumnTypePair key = new ColumnTypePair(column, FieldSpec.DataType.DOUBLE);
        Object doubleValues = (double[][])this._valuesMap.get(key);
        if (this._columnValueLoaded.add(key)) {
            if (doubleValues == null) {
                doubleValues = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
                this._valuesMap.put(key, doubleValues);
            }
            this._dataFetcher.fetchDoubleValues(column, this._docIds, this._length, (double[][])doubleValues);
        }
        return doubleValues;
    }

    public String[][] getStringValuesForMVColumn(String column) {
        ColumnTypePair key = new ColumnTypePair(column, FieldSpec.DataType.STRING);
        String[][] stringValues = (String[][])this._valuesMap.get(key);
        if (this._columnValueLoaded.add(key)) {
            if (stringValues == null) {
                stringValues = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
                this._valuesMap.put(key, stringValues);
            }
            this._dataFetcher.fetchStringValues(column, this._docIds, this._length, stringValues);
        }
        return stringValues;
    }

    public int[] getNumValuesForMVColumn(String column) {
        int[] numValues = this._numValuesMap.get(column);
        if (this._columnNumValuesLoaded.add(column)) {
            if (numValues == null) {
                numValues = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
                this._numValuesMap.put(column, numValues);
            }
            this._dataFetcher.fetchNumValues(column, this._docIds, this._length, numValues);
        }
        return numValues;
    }

    private static class ColumnTypePair {
        final String _column;
        final FieldSpec.DataType _dataType;

        ColumnTypePair(@Nonnull String column, @Nonnull FieldSpec.DataType dataType) {
            this._column = column;
            this._dataType = dataType;
        }

        public int hashCode() {
            return EqualityUtils.hashCodeOf((int)this._column.hashCode(), (int)this._dataType.hashCode());
        }

        public boolean equals(Object obj) {
            ColumnTypePair that = (ColumnTypePair)obj;
            return this._column.equals(that._column) && this._dataType == that._dataType;
        }
    }
}

