/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.text;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Stemmer {
    private char[] b = new char[50];
    private int i = 0;
    private int i_end = 0;
    private int j;
    private int k;
    private static final int INC = 50;

    public void add(char c) {
        if (this.i == this.b.length) {
            char[] cArray = new char[this.i + 50];
            for (int i = 0; i < this.i; ++i) {
                cArray[i] = this.b[i];
            }
            this.b = cArray;
        }
        this.b[this.i++] = c;
    }

    public void add(char[] cArray, int n) {
        if (this.i + n >= this.b.length) {
            char[] cArray2 = new char[this.i + n + 50];
            for (int i = 0; i < this.i; ++i) {
                cArray2[i] = this.b[i];
            }
            this.b = cArray2;
        }
        for (int i = 0; i < n; ++i) {
            this.b[this.i++] = cArray[i];
        }
    }

    public void add(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.add(string.charAt(i));
        }
    }

    public String stem(String string) {
        this.add(string);
        this.stem();
        return this.toString();
    }

    public String toString() {
        return new String(this.b, 0, this.i_end);
    }

    public int getResultLength() {
        return this.i_end;
    }

    public char[] getResultBuffer() {
        return this.b;
    }

    private final boolean cons(int n) {
        switch (this.b[n]) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return false;
            }
            case 'y': {
                return n == 0 ? true : !this.cons(n - 1);
            }
        }
        return true;
    }

    private final int m() {
        int n = 0;
        int n2 = 0;
        while (true) {
            if (n2 > this.j) {
                return n;
            }
            if (!this.cons(n2)) break;
            ++n2;
        }
        ++n2;
        while (n2 <= this.j) {
            if (!this.cons(n2)) {
                ++n2;
                continue;
            }
            ++n2;
            ++n;
            while (true) {
                if (n2 > this.j) {
                    return n;
                }
                if (!this.cons(n2)) break;
                ++n2;
            }
            ++n2;
        }
        return n;
    }

    private final boolean vowelinstem() {
        for (int i = 0; i <= this.j; ++i) {
            if (this.cons(i)) continue;
            return true;
        }
        return false;
    }

    private final boolean doublec(int n) {
        if (n < 1) {
            return false;
        }
        if (this.b[n] != this.b[n - 1]) {
            return false;
        }
        return this.cons(n);
    }

    private final boolean cvc(int n) {
        if (n < 2 || !this.cons(n) || this.cons(n - 1) || !this.cons(n - 2)) {
            return false;
        }
        char c = this.b[n];
        return c != 'w' && c != 'x' && c != 'y';
    }

    private final boolean ends(String string) {
        int n = string.length();
        int n2 = this.k - n + 1;
        if (n2 < 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.b[n2 + i] == string.charAt(i)) continue;
            return false;
        }
        this.j = this.k - n;
        return true;
    }

    private final void setto(String string) {
        int n = string.length();
        int n2 = this.j + 1;
        for (int i = 0; i < n; ++i) {
            this.b[n2 + i] = string.charAt(i);
        }
        this.k = this.j + n;
    }

    private final void r(String string) {
        if (this.m() > 0) {
            this.setto(string);
        }
    }

    private final void step1() {
        if (this.b[this.k] == 's') {
            if (this.ends("sses")) {
                this.k -= 2;
            } else if (this.ends("ies")) {
                this.setto("i");
            } else if (this.b[this.k - 1] != 's') {
                --this.k;
            }
        }
        if (this.ends("eed")) {
            if (this.m() > 0) {
                --this.k;
            }
        } else if ((this.ends("ed") || this.ends("ing")) && this.vowelinstem()) {
            this.k = this.j;
            if (this.ends("at")) {
                this.setto("ate");
            } else if (this.ends("bl")) {
                this.setto("ble");
            } else if (this.ends("iz")) {
                this.setto("ize");
            } else if (this.doublec(this.k)) {
                --this.k;
                char c = this.b[this.k];
                if (c == 'l' || c == 's' || c == 'z') {
                    ++this.k;
                }
            } else if (this.m() == 1 && this.cvc(this.k)) {
                this.setto("e");
            }
        }
    }

    private final void step2() {
        if (this.ends("y") && this.vowelinstem()) {
            this.b[this.k] = 105;
        }
    }

    private final void step3() {
        if (this.k == 0) {
            return;
        }
        switch (this.b[this.k - 1]) {
            case 'a': {
                if (this.ends("ational")) {
                    this.r("ate");
                    break;
                }
                if (!this.ends("tional")) break;
                this.r("tion");
                break;
            }
            case 'c': {
                if (this.ends("enci")) {
                    this.r("ence");
                    break;
                }
                if (!this.ends("anci")) break;
                this.r("ance");
                break;
            }
            case 'e': {
                if (!this.ends("izer")) break;
                this.r("ize");
                break;
            }
            case 'l': {
                if (this.ends("bli")) {
                    this.r("ble");
                    break;
                }
                if (this.ends("alli")) {
                    this.r("al");
                    break;
                }
                if (this.ends("entli")) {
                    this.r("ent");
                    break;
                }
                if (this.ends("eli")) {
                    this.r("e");
                    break;
                }
                if (!this.ends("ousli")) break;
                this.r("ous");
                break;
            }
            case 'o': {
                if (this.ends("ization")) {
                    this.r("ize");
                    break;
                }
                if (this.ends("ation")) {
                    this.r("ate");
                    break;
                }
                if (!this.ends("ator")) break;
                this.r("ate");
                break;
            }
            case 's': {
                if (this.ends("alism")) {
                    this.r("al");
                    break;
                }
                if (this.ends("iveness")) {
                    this.r("ive");
                    break;
                }
                if (this.ends("fulness")) {
                    this.r("ful");
                    break;
                }
                if (!this.ends("ousness")) break;
                this.r("ous");
                break;
            }
            case 't': {
                if (this.ends("aliti")) {
                    this.r("al");
                    break;
                }
                if (this.ends("iviti")) {
                    this.r("ive");
                    break;
                }
                if (!this.ends("biliti")) break;
                this.r("ble");
                break;
            }
            case 'g': {
                if (!this.ends("logi")) break;
                this.r("log");
            }
        }
    }

    private final void step4() {
        switch (this.b[this.k]) {
            case 'e': {
                if (this.ends("icate")) {
                    this.r("ic");
                    break;
                }
                if (this.ends("ative")) {
                    this.r("");
                    break;
                }
                if (!this.ends("alize")) break;
                this.r("al");
                break;
            }
            case 'i': {
                if (!this.ends("iciti")) break;
                this.r("ic");
                break;
            }
            case 'l': {
                if (this.ends("ical")) {
                    this.r("ic");
                    break;
                }
                if (!this.ends("ful")) break;
                this.r("");
                break;
            }
            case 's': {
                if (!this.ends("ness")) break;
                this.r("");
            }
        }
    }

    private final void step5() {
        if (this.k == 0) {
            return;
        }
        switch (this.b[this.k - 1]) {
            case 'a': {
                if (this.ends("al")) break;
                return;
            }
            case 'c': {
                if (this.ends("ance") || this.ends("ence")) break;
                return;
            }
            case 'e': {
                if (this.ends("er")) break;
                return;
            }
            case 'i': {
                if (this.ends("ic")) break;
                return;
            }
            case 'l': {
                if (this.ends("able") || this.ends("ible")) break;
                return;
            }
            case 'n': {
                if (this.ends("ant") || this.ends("ement") || this.ends("ment") || this.ends("ent")) break;
                return;
            }
            case 'o': {
                if (this.ends("ion") && this.j >= 0 && (this.b[this.j] == 's' || this.b[this.j] == 't') || this.ends("ou")) break;
                return;
            }
            case 's': {
                if (this.ends("ism")) break;
                return;
            }
            case 't': {
                if (this.ends("ate") || this.ends("iti")) break;
                return;
            }
            case 'u': {
                if (this.ends("ous")) break;
                return;
            }
            case 'v': {
                if (this.ends("ive")) break;
                return;
            }
            case 'z': {
                if (this.ends("ize")) break;
                return;
            }
            default: {
                return;
            }
        }
        if (this.m() > 1) {
            this.k = this.j;
        }
    }

    private final void step6() {
        int n;
        this.j = this.k;
        if (this.b[this.k] == 'e' && ((n = this.m()) > 1 || n == 1 && !this.cvc(this.k - 1))) {
            --this.k;
        }
        if (this.b[this.k] == 'l' && this.doublec(this.k) && this.m() > 1) {
            --this.k;
        }
    }

    public void stem() {
        this.k = this.i - 1;
        if (this.k > 1) {
            this.step1();
            this.step2();
            this.step3();
            this.step4();
            this.step5();
            this.step6();
        }
        this.i_end = this.k + 1;
        this.i = 0;
    }

    public static void main(String[] stringArray) {
        char[] cArray = new char[501];
        Stemmer stemmer = new Stemmer();
        block4: for (int i = 0; i < stringArray.length; ++i) {
            try {
                FileInputStream fileInputStream = new FileInputStream(stringArray[i]);
                try {
                    while (true) {
                        int n;
                        if (Character.isLetter((char)(n = fileInputStream.read()))) {
                            int n2 = 0;
                            do {
                                n = Character.toLowerCase((char)n);
                                cArray[n2] = (char)n;
                                if (n2 >= 500) continue;
                                ++n2;
                            } while (Character.isLetter((char)(n = fileInputStream.read())));
                            for (int j = 0; j < n2; ++j) {
                                stemmer.add(cArray[j]);
                            }
                            stemmer.stem();
                            String string = stemmer.toString();
                            System.out.print(string);
                        }
                        if (n < 0) continue block4;
                        System.out.print((char)n);
                    }
                }
                catch (IOException iOException) {
                    System.out.println("error reading " + stringArray[i]);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("file " + stringArray[i] + " not found");
            }
            break;
        }
    }
}

