/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.lens.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialError;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.Pair;
import org.xerial.util.ReflectionUtil;
import org.xerial.util.TypeInfo;
import org.xerial.util.lens.impl.ParameterGetter;

public abstract class RelationSetter {
    private final Class<?> coreNodeType;
    private final Class<?> attributeNodeType;
    private final String coreNodeName;
    private final String attributeNodeName;

    protected RelationSetter(Class<?> clazz, String string, Class<?> clazz2, String string2) {
        this.coreNodeType = clazz;
        this.attributeNodeType = clazz2;
        this.coreNodeName = string;
        this.attributeNodeName = string2;
    }

    public Class<?> getCoreNodeType() {
        return this.coreNodeType;
    }

    public Class<?> getAttributeNodeType() {
        return this.attributeNodeType;
    }

    public String getCoreNodeName() {
        return this.coreNodeName;
    }

    public String getAttributeNodeName() {
        return this.attributeNodeName;
    }

    public String toString() {
        return String.format("(%s[%s], %s[%s])", this.coreNodeName, this.coreNodeType.getSimpleName(), this.attributeNodeName, this.attributeNodeType.getSimpleName());
    }

    public boolean equals(Object object) {
        RelationSetter relationSetter = (RelationSetter)RelationSetter.class.cast(object);
        if (relationSetter == null) {
            return false;
        }
        boolean bl = this.coreNodeName.equals(relationSetter.coreNodeName);
        return bl ? this.attributeNodeName.equals(relationSetter.attributeNodeName) : false;
    }

    public int hashCode() {
        return this.coreNodeName.hashCode() + this.attributeNodeName.hashCode();
    }

    public abstract void bind(Object var1, Object var2, Object var3) throws XerialException;

    public static RelationSetter newRelationSetter(String string, String string2, Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 2) {
            throw new XerialError((ErrorCode)XerialErrorCode.INVALID_INPUT, method.toString());
        }
        return new MethodRelationSetter(classArray[0], string, classArray[1], string2, method);
    }

    public static RelationSetter newMapSetter(String string, String string2, Field field) {
        Pair<Class<?>, Class<?>> pair = ReflectionUtil.getGenericMapElementClasses(field);
        return new MapFieldSetter(pair.getFirst(), string, pair.getSecond(), string2, field);
    }

    private static class MapFieldSetter
    extends RelationSetter {
        private final Field mapField;
        private final ParameterGetter mapTypeGetter;
        private final Method putter;

        public MapFieldSetter(Class<?> clazz, String string, Class<?> clazz2, String string2, Field field) {
            super(clazz, string, clazz2, string2);
            this.mapField = field;
            this.mapTypeGetter = ParameterGetter.newFieldGetter(this.mapField, null);
            Class<?> clazz3 = this.mapField.getType();
            if (!TypeInfo.isMap(clazz3)) {
                throw new XerialError((ErrorCode)XerialErrorCode.InvalidType, String.format("field: %s is not a Map type", field));
            }
            try {
                this.putter = clazz3.getMethod("put", Object.class, Object.class);
            }
            catch (Exception exception) {
                throw new XerialError((ErrorCode)XerialErrorCode.INVALID_STATE, String.format("putter method is not found in %s", clazz3));
            }
        }

        @Override
        public void bind(Object object, Object object2, Object object3) throws XerialException {
            try {
                Object object4 = Map.class.cast(this.mapTypeGetter.get(object));
                if (object4 == null) {
                    object4 = TypeInfo.createInstance(this.mapField.getType());
                    ReflectionUtil.setFieldValue(object, this.mapField, object4);
                }
                this.putter.invoke(object4, object2, object3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XerialException((ErrorCode)XerialErrorCode.WRONG_DATA_TYPE, (Throwable)illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XerialException((ErrorCode)XerialErrorCode.INVALID_INPUT, (Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new XerialError((ErrorCode)XerialErrorCode.WRONG_DATA_TYPE, (Throwable)invocationTargetException);
            }
        }
    }

    private static class MethodRelationSetter
    extends RelationSetter {
        private final Method setter;

        public MethodRelationSetter(Class<?> clazz, String string, Class<?> clazz2, String string2, Method method) {
            super(clazz, string, clazz2, string2);
            this.setter = method;
        }

        @Override
        public void bind(Object object, Object object2, Object object3) throws XerialException {
            try {
                this.setter.invoke(object, object2, object3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XerialException((ErrorCode)XerialErrorCode.WRONG_DATA_TYPE, (Throwable)illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XerialException((ErrorCode)XerialErrorCode.INVALID_INPUT, (Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new XerialError((ErrorCode)XerialErrorCode.WRONG_DATA_TYPE, (Throwable)invocationTargetException);
            }
        }
    }
}

