/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.io.DBFile;

public class DiskFile
implements DBFile {
    private final RandomAccessFile file;

    public DiskFile(String string) throws FileNotFoundException {
        this.file = new RandomAccessFile(string, "rws");
    }

    public DiskFile(String string, String string2) throws FileNotFoundException {
        this.file = new RandomAccessFile(string, string2);
    }

    @Override
    public void read(byte[] byArray, int n, int n2) throws XerialException {
        assert (byArray.length >= n2);
        try {
            this.file.readFully(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IO_EXCEPTION, (Throwable)iOException);
        }
    }

    @Override
    public void seek(long l) throws XerialException {
        try {
            this.file.seek(l);
        }
        catch (IOException iOException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IO_EXCEPTION, (Throwable)iOException);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws XerialException {
        try {
            this.file.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IO_EXCEPTION, (Throwable)iOException);
        }
    }

    @Override
    public void close() throws XerialException {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IO_EXCEPTION, (Throwable)iOException);
        }
    }
}

