/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.io;

import org.xerial.util.io.Buffer;

public class BufferReader {
    private final Buffer buffer;
    private int offset;

    public BufferReader(Buffer buffer) {
        this(buffer, 0);
    }

    public BufferReader(Buffer buffer, int n) {
        this.buffer = buffer;
        this.offset = n;
    }

    public int readInt() {
        int n = this.buffer.readInt(this.offset);
        this.offset += 4;
        return n;
    }

    public long readLong() {
        long l = this.buffer.readLong(this.offset);
        this.offset += 8;
        return l;
    }

    public byte readByte() {
        byte by = this.buffer.readByte(this.offset);
        ++this.offset;
        return by;
    }

    public boolean readBoolean() {
        boolean bl = this.buffer.readBoolean(this.offset);
        ++this.offset;
        return bl;
    }
}

