/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;

public class MatrixGraph<Node> {
    private int[][] matrix;
    private HashMap<Node, Integer> nodeTable = new HashMap();
    private HashMap<Integer, Node> nodeIDToNodeTable = new HashMap();
    private int nodeCount = 0;

    public MatrixGraph(int n) {
        this.matrix = new int[n][n];
    }

    public void addNode(Node Node2) {
        int n;
        if ((n = this.nodeCount++) >= this.matrix.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.nodeTable.put(Node2, n);
        this.nodeIDToNodeTable.put(n, Node2);
    }

    public void addEdge(Node Node2, Node Node3) {
        this.matrix[this.getNodeID(Node2)][this.getNodeID(Node3)] = 1;
    }

    public int getNodeID(Node Node2) {
        if (this.nodeTable.containsKey(Node2)) {
            return this.nodeTable.get(Node2);
        }
        throw new NoSuchElementException("node " + Node2 + " is not found");
    }

    public Node getNode(int n) {
        return this.nodeIDToNodeTable.get(n);
    }

    public List<Node> getDestNodeSet(Node Node2) {
        int n = this.getNodeID(Node2);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < this.matrix.length; ++i) {
            if (this.matrix[n][i] != 1) continue;
            arrayList.add(this.getNode(i));
        }
        return arrayList;
    }

    public boolean containsNode(String string) {
        return this.nodeTable.containsKey(string);
    }

    public boolean hasEdge(Node Node2, Node Node3) {
        return this.matrix[this.getNodeID(Node2)][this.getNodeID(Node3)] == 1;
    }
}

