/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import java.util.ArrayList;
import java.util.Iterator;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialError;
import org.xerial.core.XerialErrorCode;
import org.xerial.util.BitVector;
import org.xerial.util.StringUtil;
import org.xerial.util.graph.Lattice;

public class LatticeNode<T>
implements Iterable<T> {
    private int id = -1;
    private final Lattice<T> lattice;
    private final BitVector elementOnOffIndicator;

    public LatticeNode(Lattice<T> lattice, BitVector bitVector) {
        this.lattice = lattice;
        this.elementOnOffIndicator = bitVector;
    }

    public void setID(int n) {
        this.id = n;
    }

    public int getID() {
        assert (this.id != -1);
        return this.id;
    }

    BitVector getElementOnOffIndicator() {
        return this.elementOnOffIndicator;
    }

    public boolean contains(T t) {
        int n = this.lattice.getElementID(t);
        if (n == -1) {
            return false;
        }
        return this.elementOnOffIndicator.get(n);
    }

    public LatticeNode<T> next(T t) {
        return this.lattice.next(this, t);
    }

    public LatticeNode<T> back(T t) {
        return this.lattice.back(this, t);
    }

    public boolean equals(Object object) {
        if (!this.getClass().isInstance(object)) {
            return false;
        }
        LatticeNode latticeNode = (LatticeNode)object;
        return this.lattice == latticeNode.lattice && this.elementOnOffIndicator.equals(latticeNode.elementOnOffIndicator);
    }

    public int hashCode() {
        int n = 3;
        n += this.lattice.hashCode() * 31;
        return (n += this.elementOnOffIndicator.hashCode() * 31) % 1987;
    }

    public String toString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.elementOnOffIndicator.size(); ++i) {
            if (!this.elementOnOffIndicator.get(i)) continue;
            T t = this.lattice.getElementByID(i);
            if (t == null) {
                throw new XerialError((ErrorCode)XerialErrorCode.MISSING_ELEMENT, "element id=" + i);
            }
            arrayList.add(t.toString());
        }
        return String.format("{%s}", StringUtil.join(arrayList, ", "));
    }

    @Override
    public Iterator<T> iterator() {
        return new NodeSetIterator();
    }

    private class NodeSetIterator
    implements Iterator<T> {
        int cursor = -1;

        private NodeSetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() != -1;
        }

        private int nextIndex() {
            for (int i = this.cursor + 1; i < LatticeNode.this.elementOnOffIndicator.size(); ++i) {
                if (!LatticeNode.this.elementOnOffIndicator.get(i)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public T next() {
            this.cursor = this.nextIndex();
            if (this.cursor != -1) {
                Object t = LatticeNode.this.lattice.getElementByID(this.cursor);
                return t;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

