/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.bean.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.TypeInfo;
import org.xerial.util.bean.BeanBinder;

abstract class BeanBinderBase
implements BeanBinder {
    Method method;
    String parameterName;

    public BeanBinderBase(Method method, String string) {
        this.method = method;
        this.parameterName = string;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(Method method) {
        this.method = method;
    }

    @Override
    public String toString() {
        return "(" + this.method.toString() + ") ";
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public void setParameterName(String string) {
        this.parameterName = string;
    }

    public static void constractableTest(Class<?> clazz) throws XerialException {
        if (!TypeInfo.canInstantiate(clazz)) {
            throw new XerialException((ErrorCode)XerialErrorCode.NoPublicConstructor, clazz + " has no public constructor");
        }
    }

    protected void invokeMethod(Object object, Object[] objectArray) throws XerialException {
        try {
            this.getMethod().invoke(object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IllegalArgument, (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IllegalAccess, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XerialException((ErrorCode)XerialErrorCode.InvocationTargetException, (Throwable)invocationTargetException);
        }
    }
}

